/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.osgi.hook;

import com.atlassian.plugin.osgi.container.PackageScannerConfiguration;
import com.atlassian.plugin.osgi.hook.DmzResolverHook;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import org.osgi.framework.hooks.resolver.ResolverHook;
import org.osgi.framework.hooks.resolver.ResolverHookFactory;
import org.osgi.framework.wiring.BundleRevision;

public class DmzResolverHookFactory
implements ResolverHookFactory {
    private final Set<String> applicationBundledInternalPlugins;
    private final Set<String> osgiPublicPackages;
    private final Set<String> osgiPublicPackagesExcludes;

    public DmzResolverHookFactory(PackageScannerConfiguration packageScannerConfig) {
        Objects.requireNonNull(packageScannerConfig, "Configuration required.");
        this.applicationBundledInternalPlugins = packageScannerConfig.getApplicationBundledInternalPlugins();
        this.osgiPublicPackages = packageScannerConfig.getOsgiPublicPackages();
        this.osgiPublicPackagesExcludes = packageScannerConfig.getOsgiPublicPackagesExcludes();
    }

    public ResolverHook begin(Collection<BundleRevision> triggers) {
        return new DmzResolverHook(this.applicationBundledInternalPlugins, this.osgiPublicPackages, this.osgiPublicPackagesExcludes);
    }
}

