/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.osgi.factory.transform.stage;

import aQute.lib.osgi.Builder;
import aQute.lib.osgi.Jar;
import com.atlassian.plugin.PluginInformation;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.osgi.factory.transform.PluginTransformationException;
import com.atlassian.plugin.osgi.factory.transform.TransformContext;
import com.atlassian.plugin.osgi.factory.transform.TransformStage;
import com.atlassian.plugin.osgi.factory.transform.model.SystemExports;
import com.atlassian.plugin.osgi.util.OsgiHeaderUtil;
import com.atlassian.plugin.parsers.XmlDescriptorParser;
import com.atlassian.plugin.util.PluginUtils;
import com.google.common.collect.ImmutableSet;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.apache.commons.lang.StringUtils;
import org.osgi.framework.Version;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenerateManifestStage
implements TransformStage {
    private static final Logger log = LoggerFactory.getLogger(GenerateManifestStage.class);
    private final int SPRING_TIMEOUT = PluginUtils.getDefaultEnablingWaitPeriod();
    private final String SPRING_CONTEXT_DEFAULT = "*;timeout:=" + this.SPRING_TIMEOUT;
    public static final String SPRING_CONTEXT = "Spring-Context";
    private static final String SPRING_CONTEXT_TIMEOUT = "timeout:=";
    private static final String SPRING_CONTEXT_DELIM = ";";
    private static final String RESOLUTION_DIRECTIVE = "resolution:";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(TransformContext context) throws PluginTransformationException {
        Builder builder = new Builder();
        try {
            Manifest mf;
            builder.setJar(context.getPluginFile());
            XmlDescriptorParser parser = new XmlDescriptorParser(context.getDescriptorDocument(), (Set)ImmutableSet.of());
            Manifest contextManifest = context.getManifest();
            if (this.isOsgiBundle(contextManifest)) {
                if (context.getExtraImports().isEmpty()) {
                    boolean modified = false;
                    Manifest mf2 = builder.getJar().getManifest();
                    for (Map.Entry<String, String> entry : this.getRequiredOsgiHeaders(context, parser.getKey()).entrySet()) {
                        if (!this.manifestDoesntHaveRequiredOsgiHeader(mf2, entry)) continue;
                        mf2.getMainAttributes().putValue(entry.getKey(), entry.getValue());
                        modified = true;
                    }
                    this.validateOsgiVersionIsValid(mf2);
                    if (modified) {
                        this.writeManifestOverride(context, mf2);
                    }
                    return;
                }
                this.assertSpringAvailableIfRequired(context);
                mf = builder.getJar().getManifest();
                String imports = this.addExtraImports(builder.getJar().getManifest().getMainAttributes().getValue("Import-Package"), context.getExtraImports());
                mf.getMainAttributes().putValue("Import-Package", imports);
                for (Map.Entry<String, String> entry : this.getRequiredOsgiHeaders(context, parser.getKey()).entrySet()) {
                    mf.getMainAttributes().putValue(entry.getKey(), entry.getValue());
                }
            } else {
                PluginInformation info = parser.getPluginInformation();
                Properties properties = new Properties();
                for (Map.Entry<String, String> entry : this.getRequiredOsgiHeaders(context, parser.getKey()).entrySet()) {
                    properties.put(entry.getKey(), entry.getValue());
                }
                Set scanFolders = info.getModuleScanFolders();
                if (!scanFolders.isEmpty()) {
                    properties.put("Atlassian-Scan-Folders", StringUtils.join((Collection)scanFolders, (String)","));
                }
                properties.put("Bundle-SymbolicName", parser.getKey());
                properties.put("Import-Package", "*;resolution:=optional");
                properties.put("Bundle-Version", info.getVersion());
                properties.put("-removeheaders", "Include-Resource");
                GenerateManifestStage.header(properties, "Bundle-Description", info.getDescription());
                GenerateManifestStage.header(properties, "Bundle-Name", parser.getKey());
                GenerateManifestStage.header(properties, "Bundle-Vendor", info.getVendorName());
                GenerateManifestStage.header(properties, "Bundle-DocURL", info.getVendorUrl());
                ArrayList<String> bundleClassPaths = new ArrayList<String>();
                bundleClassPaths.add(".");
                ArrayList<String> innerClassPaths = new ArrayList<String>(context.getBundleClassPathJars());
                Collections.sort(innerClassPaths);
                bundleClassPaths.addAll(innerClassPaths);
                GenerateManifestStage.header(properties, "Bundle-ClassPath", StringUtils.join(bundleClassPaths, (char)','));
                properties.putAll(context.getBndInstructions());
                properties.put("Import-Package", this.addExtraImports(properties.getProperty("Import-Package"), context.getExtraImports()));
                if (!properties.containsKey("Export-Package")) {
                    properties.put("Export-Package", StringUtils.join(context.getExtraExports(), (char)','));
                }
                builder.setProperties(properties);
                builder.calcManifest();
                builder.getJar().close();
                Jar jar = null;
                try {
                    jar = builder.build();
                    mf = jar.getManifest();
                }
                finally {
                    if (jar != null) {
                        jar.close();
                    }
                }
                Attributes attributes = mf.getMainAttributes();
                for (Map.Entry<Object, Object> entry : contextManifest.getMainAttributes().entrySet()) {
                    Object name = entry.getKey();
                    if (attributes.containsKey(name)) {
                        log.debug("Ignoring manifest header {} from {} due to transformer override", name, (Object)context.getPluginArtifact());
                        continue;
                    }
                    attributes.put(name, entry.getValue());
                }
            }
            this.enforceHostVersionsForUnknownImports(mf, context.getSystemExports());
            this.validateOsgiVersionIsValid(mf);
            this.writeManifestOverride(context, mf);
        }
        catch (Exception t) {
            throw new PluginParseException("Unable to process plugin to generate OSGi manifest", (Throwable)t);
        }
        finally {
            builder.getJar().close();
            builder.close();
        }
    }

    private Map<String, String> getRequiredOsgiHeaders(TransformContext context, String pluginKey) {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("Atlassian-Plugin-Key", pluginKey);
        String springHeader = this.getDesiredSpringContextValue(context);
        if (springHeader != null) {
            props.put(SPRING_CONTEXT, springHeader);
        }
        return props;
    }

    private String getDesiredSpringContextValue(TransformContext context) {
        String header = context.getManifest().getMainAttributes().getValue(SPRING_CONTEXT);
        if (header != null) {
            return this.ensureDefaultTimeout(header);
        }
        if (context.getPluginArtifact().doesResourceExist("META-INF/spring/") || context.shouldRequireSpring() || context.getDescriptorDocument() != null) {
            return this.SPRING_CONTEXT_DEFAULT;
        }
        return null;
    }

    private String ensureDefaultTimeout(String header) {
        StringBuilder headerBuf;
        boolean noTimeOutSpecified = StringUtils.isEmpty((String)System.getProperty("atlassian.plugins.enable.wait"));
        if (noTimeOutSpecified) {
            return header;
        }
        if (header.contains(SPRING_CONTEXT_TIMEOUT)) {
            StringTokenizer tokenizer = new StringTokenizer(header, SPRING_CONTEXT_DELIM);
            headerBuf = new StringBuilder();
            while (tokenizer.hasMoreElements()) {
                String directive = (String)tokenizer.nextElement();
                if (directive.startsWith(SPRING_CONTEXT_TIMEOUT)) {
                    directive = SPRING_CONTEXT_TIMEOUT + this.SPRING_TIMEOUT;
                }
                headerBuf.append(directive);
                if (!tokenizer.hasMoreElements()) continue;
                headerBuf.append(SPRING_CONTEXT_DELIM);
            }
        } else {
            headerBuf = new StringBuilder(header);
            headerBuf.append(";timeout:=");
            headerBuf.append(this.SPRING_TIMEOUT);
        }
        return headerBuf.toString();
    }

    private void validateOsgiVersionIsValid(Manifest mf) {
        String version = mf.getMainAttributes().getValue("Bundle-Version");
        try {
            if (Version.parseVersion((String)version) == Version.emptyVersion) {
                throw new IllegalArgumentException();
            }
        }
        catch (IllegalArgumentException ex) {
            throw new IllegalArgumentException("Plugin version '" + version + "' is required and must be able to be " + "parsed as an OSGi version - MAJOR.MINOR.MICRO.QUALIFIER");
        }
    }

    private void writeManifestOverride(TransformContext context, Manifest mf) throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        mf.write(bout);
        context.getFileOverrides().put("META-INF/MANIFEST.MF", bout.toByteArray());
    }

    private void enforceHostVersionsForUnknownImports(Manifest manifest, SystemExports exports) {
        String origImports = manifest.getMainAttributes().getValue("Import-Package");
        if (origImports != null) {
            StringBuilder imports = new StringBuilder();
            Map<String, Map<String, String>> header = OsgiHeaderUtil.parseHeader(origImports);
            for (Map.Entry<String, Map<String, String>> pkgImport : header.entrySet()) {
                String export;
                String imp = null;
                if (pkgImport.getValue().isEmpty() && !(export = exports.getFullExport(pkgImport.getKey())).equals(imp)) {
                    imp = export;
                }
                if (imp == null) {
                    imp = OsgiHeaderUtil.buildHeader(pkgImport.getKey(), pkgImport.getValue());
                }
                imports.append(imp);
                imports.append(",");
            }
            if (imports.length() > 0) {
                imports.deleteCharAt(imports.length() - 1);
            }
            manifest.getMainAttributes().putValue("Import-Package", imports.toString());
        }
    }

    private boolean isOsgiBundle(Manifest manifest) throws IOException {
        return manifest.getMainAttributes().getValue("Bundle-SymbolicName") != null;
    }

    private String addExtraImports(String importsLine, List<String> extraImports) {
        Map<String, Map<String, String>> originalImports = OsgiHeaderUtil.parseHeader(importsLine);
        for (String exImport : extraImports) {
            if (exImport.startsWith("java.")) continue;
            String extraImportPackage = StringUtils.split((String)exImport, (char)';')[0];
            Map<String, String> attrs = originalImports.get(extraImportPackage);
            if (attrs != null) {
                String resolution = attrs.get(RESOLUTION_DIRECTIVE);
                if (!"optional".equals(resolution)) continue;
                attrs.put(RESOLUTION_DIRECTIVE, "mandatory");
                continue;
            }
            originalImports.put(exImport, Collections.emptyMap());
        }
        return OsgiHeaderUtil.buildHeader(originalImports);
    }

    private boolean manifestDoesntHaveRequiredOsgiHeader(Manifest mf, Map.Entry<String, String> entry) {
        if (mf.getMainAttributes().containsKey(new Attributes.Name(entry.getKey()))) {
            return !entry.getValue().equals(mf.getMainAttributes().getValue(entry.getKey()));
        }
        return true;
    }

    private static void header(Properties properties, String key, Object value) {
        if (value == null) {
            return;
        }
        if (value instanceof Collection && ((Collection)value).isEmpty()) {
            return;
        }
        properties.put(key, value.toString().replaceAll("[\r\n]", ""));
    }

    private void assertSpringAvailableIfRequired(TransformContext context) {
        if (PluginUtils.isAtlassianDevMode() && context.shouldRequireSpring()) {
            String header = context.getManifest().getMainAttributes().getValue(SPRING_CONTEXT);
            if (header == null) {
                log.debug("Manifest has no 'Spring-Context:' header. Prefer the header 'Spring-Context: *' in the jar '{}'.", (Object)context.getPluginArtifact());
            } else if (header.contains(";timeout:=")) {
                log.warn("Manifest contains a 'Spring-Context:' header with a timeout, namely '{}'. This can cause problems as the timeout is server specific. Use the header 'Spring-Context: *' in the jar '{}'.", (Object)header, (Object)context.getPluginArtifact());
            }
        }
    }
}

