/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.osgi.container.felix;

import com.atlassian.plugin.event.PluginEventListener;
import com.atlassian.plugin.event.PluginEventManager;
import com.atlassian.plugin.event.events.PluginFrameworkShutdownEvent;
import com.atlassian.plugin.event.events.PluginFrameworkStartingEvent;
import com.atlassian.plugin.event.events.PluginFrameworkWarmRestartingEvent;
import com.atlassian.plugin.event.events.PluginUninstalledEvent;
import com.atlassian.plugin.event.events.PluginUpgradedEvent;
import com.atlassian.plugin.osgi.container.OsgiContainerException;
import com.atlassian.plugin.osgi.container.OsgiContainerManager;
import com.atlassian.plugin.osgi.container.OsgiContainerStartedEvent;
import com.atlassian.plugin.osgi.container.OsgiContainerStoppedEvent;
import com.atlassian.plugin.osgi.container.OsgiPersistentCache;
import com.atlassian.plugin.osgi.container.PackageScannerConfiguration;
import com.atlassian.plugin.osgi.container.felix.ExportsBuilder;
import com.atlassian.plugin.osgi.container.felix.FelixLoggerBridge;
import com.atlassian.plugin.osgi.container.impl.DefaultOsgiPersistentCache;
import com.atlassian.plugin.osgi.hostcomponents.HostComponentProvider;
import com.atlassian.plugin.osgi.hostcomponents.HostComponentRegistration;
import com.atlassian.plugin.osgi.hostcomponents.impl.DefaultComponentRegistrar;
import com.atlassian.plugin.osgi.util.OsgiHeaderUtil;
import com.atlassian.plugin.util.ClassLoaderUtils;
import com.atlassian.plugin.util.ContextClassLoaderSwitchingUtil;
import com.atlassian.plugin.util.FileUtils;
import com.atlassian.plugin.util.PluginUtils;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.jar.JarFile;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.framework.Felix;
import org.apache.felix.framework.util.StringMap;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleException;
import org.osgi.framework.BundleListener;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FelixOsgiContainerManager
implements OsgiContainerManager {
    public static final String OSGI_FRAMEWORK_BUNDLES_ZIP = "osgi-framework-bundles.zip";
    public static final int REFRESH_TIMEOUT = 10;
    private static final Logger log = LoggerFactory.getLogger(FelixOsgiContainerManager.class);
    private static final String OSGI_BOOTDELEGATION = "org.osgi.framework.bootdelegation";
    private static final String ATLASSIAN_PREFIX = "atlassian.";
    private final OsgiPersistentCache persistentCache;
    private final URL frameworkBundlesUrl;
    private final PackageScannerConfiguration packageScannerConfig;
    private final HostComponentProvider hostComponentProvider;
    private final List<ServiceTracker> trackers;
    private final ExportsBuilder exportsBuilder;
    private final ThreadFactory threadFactory = new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = new Thread(r, "Felix:Startup");
            thread.setDaemon(true);
            return thread;
        }
    };
    private BundleRegistration registration = null;
    private Felix felix = null;
    private boolean felixRunning = false;
    private boolean disableMultipleBundleVersions = true;
    private org.apache.felix.framework.Logger felixLogger;
    private final PluginEventManager pluginEventManager;

    @Deprecated
    public FelixOsgiContainerManager(File frameworkBundlesDir, PackageScannerConfiguration packageScannerConfig, HostComponentProvider provider, PluginEventManager eventManager) {
        this(ClassLoaderUtils.getResource((String)OSGI_FRAMEWORK_BUNDLES_ZIP, FelixOsgiContainerManager.class), frameworkBundlesDir, packageScannerConfig, provider, eventManager);
    }

    @Deprecated
    public FelixOsgiContainerManager(URL frameworkBundlesZip, File frameworkBundlesDir, PackageScannerConfiguration packageScannerConfig, HostComponentProvider provider, PluginEventManager eventManager) {
        this(frameworkBundlesZip, new DefaultOsgiPersistentCache(new File(frameworkBundlesDir.getParentFile(), "osgi-cache")), packageScannerConfig, provider, eventManager);
    }

    public FelixOsgiContainerManager(OsgiPersistentCache persistentCache, PackageScannerConfiguration packageScannerConfig, HostComponentProvider provider, PluginEventManager eventManager) {
        this(ClassLoaderUtils.getResource((String)OSGI_FRAMEWORK_BUNDLES_ZIP, FelixOsgiContainerManager.class), persistentCache, packageScannerConfig, provider, eventManager);
    }

    public FelixOsgiContainerManager(URL frameworkBundlesZip, OsgiPersistentCache persistentCache, PackageScannerConfiguration packageScannerConfig, HostComponentProvider provider, PluginEventManager eventManager) throws OsgiContainerException {
        Preconditions.checkNotNull((Object)frameworkBundlesZip, (Object)"The framework bundles zip is required");
        Preconditions.checkNotNull((Object)persistentCache, (Object)"The framework bundles directory must not be null");
        Preconditions.checkNotNull((Object)packageScannerConfig, (Object)"The package scanner configuration must not be null");
        Preconditions.checkNotNull((Object)eventManager, (Object)"The plugin event manager is required");
        this.frameworkBundlesUrl = frameworkBundlesZip;
        this.packageScannerConfig = packageScannerConfig;
        this.persistentCache = persistentCache;
        this.hostComponentProvider = provider;
        this.trackers = Collections.synchronizedList(new ArrayList());
        this.pluginEventManager = eventManager;
        eventManager.register((Object)this);
        this.felixLogger = new FelixLoggerBridge(log);
        this.exportsBuilder = new ExportsBuilder();
    }

    public void setFelixLogger(org.apache.felix.framework.Logger logger) {
        this.felixLogger = logger;
    }

    public void setDisableMultipleBundleVersions(boolean val) {
        this.disableMultipleBundleVersions = val;
    }

    public void clearExportCache() {
        this.exportsBuilder.clearExportCache();
    }

    @PluginEventListener
    public void onStart(PluginFrameworkStartingEvent event) {
        this.start();
    }

    @PluginEventListener
    public void onShutdown(PluginFrameworkShutdownEvent event) {
        this.stop();
    }

    @PluginEventListener
    public void onPluginUpgrade(PluginUpgradedEvent event) {
        this.registration.refreshPackages();
    }

    @PluginEventListener
    public void onPluginUninstallation(PluginUninstalledEvent event) {
        this.registration.refreshPackages();
    }

    @PluginEventListener
    public void onPluginFrameworkWarmRestarting(PluginFrameworkWarmRestartingEvent event) {
        this.registration.loadHostComponents(this.collectHostComponents(this.hostComponentProvider));
    }

    @Override
    public void start() throws OsgiContainerException {
        if (this.isRunning()) {
            return;
        }
        DefaultComponentRegistrar registrar = this.collectHostComponents(this.hostComponentProvider);
        StringMap configMap = new StringMap();
        configMap.put((Object)"org.osgi.framework.system.packages.extra", (Object)this.exportsBuilder.getExports(registrar.getRegistry(), this.packageScannerConfig));
        configMap.put((Object)"felix.cache.rootdir", (Object)this.persistentCache.getOsgiBundleCache().getAbsolutePath());
        configMap.put((Object)"felix.log.level", (Object)String.valueOf(this.felixLogger.getLogLevel()));
        configMap.put((Object)"felix.log.logger", (Object)this.felixLogger);
        String bootDelegation = this.getAtlassianSpecificOsgiSystemProperty(OSGI_BOOTDELEGATION);
        if (bootDelegation == null || bootDelegation.trim().length() == 0) {
            bootDelegation = "weblogic,weblogic.*,META-INF.services,com.yourkit,com.yourkit.*,com.chronon,com.chronon.*,com.jprofiler,com.jprofiler.*,org.apache.xerces,org.apache.xerces.*,org.apache.xalan,org.apache.xalan.*,org.apache.xml.serializer,sun.*,com.sun.xml.bind.v2,com.icl.saxon";
        }
        configMap.put((Object)OSGI_BOOTDELEGATION, (Object)bootDelegation);
        configMap.put((Object)"felix.bootdelegation.implicit", (Object)"false");
        configMap.put((Object)"org.osgi.framework.bundle.parent", (Object)"framework");
        if (log.isDebugEnabled()) {
            log.debug("Felix configuration: " + configMap);
        }
        this.validateConfiguration(configMap);
        try {
            this.registration = new BundleRegistration(this.frameworkBundlesUrl, this.persistentCache.getFrameworkBundleCache(), registrar);
            ArrayList<BundleRegistration> list = new ArrayList<BundleRegistration>();
            list.add(this.registration);
            configMap.put((Object)"felix.systembundle.activators", list);
            this.felix = new Felix((Map)configMap);
            Runnable start = new Runnable(){

                @Override
                public void run() {
                    try {
                        Thread.currentThread().setContextClassLoader(null);
                        FelixOsgiContainerManager.this.felix.start();
                        FelixOsgiContainerManager.this.felixRunning = true;
                    }
                    catch (BundleException e) {
                        throw new OsgiContainerException("Unable to start felix", e);
                    }
                }
            };
            Thread t = this.threadFactory.newThread(start);
            t.start();
            t.join(600000L);
        }
        catch (Exception ex) {
            throw new OsgiContainerException("Unable to start OSGi container", ex);
        }
        this.pluginEventManager.broadcast((Object)new OsgiContainerStartedEvent(this));
    }

    private void validateConfiguration(StringMap configMap) throws OsgiContainerException {
        String systemExports = (String)configMap.get((Object)"org.osgi.framework.system.packages.extra");
        String cacheKeySource = StringUtils.join((Object[])new Object[]{this.getRuntimeEnvironment(), systemExports}, (char)',');
        this.validateCaches(cacheKeySource);
        this.detectIncorrectOsgiVersion();
        this.detectXercesOverride(systemExports);
    }

    void detectXercesOverride(String systemExports) throws OsgiContainerException {
        int pos = systemExports.indexOf("org.apache.xerces.util");
        if (pos > -1 && (pos == 0 || pos > 0 && systemExports.charAt(pos - 1) == ',') && ((pos += "org.apache.xerces.util".length()) >= systemExports.length() || ';' != systemExports.charAt(pos))) {
            throw new OsgiContainerException("Detected an incompatible version of Apache Xerces on the classpath.  If using Tomcat, you may have an old version of Xerces in $TOMCAT_HOME/common/lib/endorsed that will need to be removed.");
        }
    }

    private void validateCaches(String cacheKeySource) {
        log.info("Using Felix bundle cacheKey source: {}", (Object)cacheKeySource);
        this.persistentCache.validate(cacheKeySource);
        log.debug("Using Felix bundle cache directory: {}", (Object)this.persistentCache.getOsgiBundleCache().getAbsolutePath());
    }

    private void detectIncorrectOsgiVersion() {
        try {
            Bundle.class.getMethod("getBundleContext", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new OsgiContainerException("Detected older version (4.0 or earlier) of OSGi.  If using WebSphere 6.1, please enable application-first (parent-last) classloading and the 'Single classloader for application' WAR classloader policy.");
        }
    }

    @Override
    public void stop() throws OsgiContainerException {
        if (this.felixRunning) {
            for (ServiceTracker tracker : new HashSet<ServiceTracker>(this.trackers)) {
                tracker.close();
            }
            FrameworkListener listener = new FrameworkListener(){

                public void frameworkEvent(FrameworkEvent event) {
                    if (event.getType() == 512) {
                        log.error("Timeout waiting for OSGi to shutdown");
                        FelixOsgiContainerManager.this.threadDump();
                    } else if (event.getType() == 64) {
                        log.info("OSGi shutdown successful");
                    }
                }
            };
            try {
                this.felix.getBundleContext().addFrameworkListener(listener);
                this.felix.stop();
                this.felix.waitForStop(TimeUnit.SECONDS.toMillis(60L));
            }
            catch (InterruptedException e) {
                log.warn("Interrupting Felix shutdown", (Throwable)e);
            }
            catch (BundleException ex) {
                log.error("An error occurred while stopping the Felix OSGi Container. ", (Throwable)ex);
            }
        }
        this.felixRunning = false;
        this.felix = null;
        this.pluginEventManager.broadcast((Object)new OsgiContainerStoppedEvent(this));
    }

    private void threadDump() {
        StringBuilder sb = new StringBuilder();
        String nl = System.getProperty("line.separator");
        for (Map.Entry<Thread, StackTraceElement[]> entry : Thread.getAllStackTraces().entrySet()) {
            Thread key = entry.getKey();
            StackTraceElement[] trace = entry.getValue();
            sb.append(key).append(nl);
            for (StackTraceElement aTrace : trace) {
                sb.append(" ").append(aTrace).append(nl);
            }
        }
        log.debug("Thread dump: " + nl + sb.toString());
    }

    @Override
    public Bundle[] getBundles() {
        if (this.isRunning()) {
            return this.registration.getBundles();
        }
        throw new IllegalStateException("Cannot retrieve the bundles if the Felix container isn't running. Check earlier in the logs for the possible cause as to why Felix didn't start correctly.");
    }

    @Override
    public ServiceReference[] getRegisteredServices() {
        return this.felix.getRegisteredServices();
    }

    @Override
    public ServiceTracker getServiceTracker(String interfaceClassName) {
        return this.getServiceTracker(interfaceClassName, null);
    }

    @Override
    public ServiceTracker getServiceTracker(String interfaceClassName, ServiceTrackerCustomizer serviceTrackerCustomizer) {
        if (!this.isRunning()) {
            throw new IllegalStateException("Unable to create a tracker when osgi is not running");
        }
        ServiceTracker tracker = this.registration.getServiceTracker(interfaceClassName, this.trackers, serviceTrackerCustomizer);
        tracker.open();
        this.trackers.add(tracker);
        return tracker;
    }

    @Override
    public Bundle installBundle(File file) throws OsgiContainerException {
        try {
            return this.registration.install(file, this.disableMultipleBundleVersions);
        }
        catch (BundleException e) {
            throw new OsgiContainerException("Unable to install bundle", e);
        }
    }

    DefaultComponentRegistrar collectHostComponents(HostComponentProvider provider) {
        DefaultComponentRegistrar registrar = new DefaultComponentRegistrar();
        if (provider != null) {
            provider.provide(registrar);
        }
        return registrar;
    }

    @Override
    public boolean isRunning() {
        return this.felixRunning;
    }

    @Override
    public List<HostComponentRegistration> getHostComponentRegistrations() {
        return this.registration.getHostComponentRegistrations();
    }

    private String getAtlassianSpecificOsgiSystemProperty(String originalSystemProperty) {
        return System.getProperty(ATLASSIAN_PREFIX + originalSystemProperty);
    }

    @VisibleForTesting
    String getRuntimeEnvironment() {
        return String.format("java.version=%s,plugin.enable.timeout=%d", System.getProperty("java.version"), PluginUtils.getDefaultEnablingWaitPeriod());
    }

    static class BundleRegistration
    implements BundleActivator,
    BundleListener,
    FrameworkListener {
        private BundleContext bundleContext;
        private DefaultComponentRegistrar registrar;
        private List<ServiceRegistration> hostServicesReferences;
        private List<HostComponentRegistration> hostComponentRegistrations;
        private final URL frameworkBundlesUrl;
        private final File frameworkBundlesDir;
        private ClassLoader initializedClassLoader;
        private PackageAdmin packageAdmin;

        public BundleRegistration(URL frameworkBundlesUrl, File frameworkBundlesDir, DefaultComponentRegistrar registrar) {
            this.registrar = registrar;
            this.frameworkBundlesUrl = frameworkBundlesUrl;
            this.frameworkBundlesDir = frameworkBundlesDir;
            this.initializedClassLoader = Thread.currentThread().getContextClassLoader();
        }

        public void start(BundleContext context) throws Exception {
            this.bundleContext = context;
            ServiceReference ref = context.getServiceReference(PackageAdmin.class.getName());
            this.packageAdmin = (PackageAdmin)context.getService(ref);
            context.addBundleListener((BundleListener)this);
            context.addFrameworkListener((FrameworkListener)this);
            this.loadHostComponents(this.registrar);
            this.extractAndInstallFrameworkBundles();
        }

        public void stop(BundleContext ctx) throws Exception {
            ctx.removeBundleListener((BundleListener)this);
            ctx.removeFrameworkListener((FrameworkListener)this);
            if (this.hostServicesReferences != null) {
                for (ServiceRegistration ref : this.hostServicesReferences) {
                    ref.unregister();
                }
            }
            this.bundleContext = null;
            this.packageAdmin = null;
            this.hostServicesReferences = null;
            this.hostComponentRegistrations = null;
            this.registrar = null;
            this.initializedClassLoader = null;
        }

        public void bundleChanged(BundleEvent evt) {
            switch (evt.getType()) {
                case 1: {
                    log.info("Installed bundle " + evt.getBundle().getSymbolicName() + " (" + evt.getBundle().getBundleId() + ")");
                    break;
                }
                case 32: {
                    log.info("Resolved bundle " + evt.getBundle().getSymbolicName() + " (" + evt.getBundle().getBundleId() + ")");
                    break;
                }
                case 64: {
                    log.info("Unresolved bundle " + evt.getBundle().getSymbolicName() + " (" + evt.getBundle().getBundleId() + ")");
                    break;
                }
                case 2: {
                    log.info("Started bundle " + evt.getBundle().getSymbolicName() + " (" + evt.getBundle().getBundleId() + ")");
                    break;
                }
                case 4: {
                    log.info("Stopped bundle " + evt.getBundle().getSymbolicName() + " (" + evt.getBundle().getBundleId() + ")");
                    break;
                }
                case 16: {
                    log.info("Uninstalled bundle " + evt.getBundle().getSymbolicName() + " (" + evt.getBundle().getBundleId() + ")");
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Bundle install(File path, boolean uninstallOtherVersions) throws BundleException {
            boolean bundleUninstalled = false;
            if (uninstallOtherVersions) {
                try {
                    JarFile jar = new JarFile(path);
                    String pluginKey = null;
                    try {
                        pluginKey = OsgiHeaderUtil.getPluginKey(jar.getManifest());
                    }
                    finally {
                        jar.close();
                    }
                    for (Bundle oldBundle : this.bundleContext.getBundles()) {
                        if (!pluginKey.equals(OsgiHeaderUtil.getPluginKey(oldBundle))) continue;
                        log.info("Uninstalling existing version " + oldBundle.getHeaders().get("Bundle-Version"));
                        oldBundle.uninstall();
                        bundleUninstalled = true;
                    }
                }
                catch (IOException e) {
                    throw new BundleException("Invalid bundle format", (Throwable)e);
                }
            }
            Bundle bundle = this.bundleContext.installBundle(path.toURI().toString());
            if (bundleUninstalled) {
                this.refreshPackages();
            }
            return bundle;
        }

        public Bundle[] getBundles() {
            return this.bundleContext.getBundles();
        }

        public ServiceTracker getServiceTracker(String clazz, Collection<ServiceTracker> trackedTrackers) {
            return this.getServiceTracker(clazz, trackedTrackers, null);
        }

        public ServiceTracker getServiceTracker(String clazz, final Collection<ServiceTracker> trackedTrackers, ServiceTrackerCustomizer customizer) {
            return new ServiceTracker(this.bundleContext, clazz, customizer){

                public void close() {
                    super.close();
                    trackedTrackers.remove((Object)this);
                }
            };
        }

        public List<HostComponentRegistration> getHostComponentRegistrations() {
            return this.hostComponentRegistrations;
        }

        void loadHostComponents(final DefaultComponentRegistrar registrar) {
            if (this.hostServicesReferences != null) {
                for (ServiceRegistration reg : this.hostServicesReferences) {
                    reg.unregister();
                }
            }
            ContextClassLoaderSwitchingUtil.runInContext((ClassLoader)this.initializedClassLoader, (Runnable)new Runnable(){

                @Override
                public void run() {
                    BundleRegistration.this.hostServicesReferences = registrar.writeRegistry(BundleRegistration.this.bundleContext);
                    BundleRegistration.this.hostComponentRegistrations = registrar.getRegistry();
                }
            });
        }

        private void extractAndInstallFrameworkBundles() throws BundleException {
            ArrayList<Bundle> bundles = new ArrayList<Bundle>();
            FileUtils.conditionallyExtractZipFile((URL)this.frameworkBundlesUrl, (File)this.frameworkBundlesDir);
            for (File bundleFile : this.frameworkBundlesDir.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File file, String s) {
                    return s.endsWith(".jar");
                }
            })) {
                bundles.add(this.install(bundleFile, false));
            }
            this.packageAdmin.resolveBundles(null);
            for (Bundle bundle : bundles) {
                if (bundle.getHeaders().get("Fragment-Host") != null) continue;
                bundle.start();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void refreshPackages() {
            final CountDownLatch latch = new CountDownLatch(1);
            FrameworkListener refreshListener = new FrameworkListener(){

                public void frameworkEvent(FrameworkEvent event) {
                    if (event.getType() == 4) {
                        log.info("Packages refreshed");
                        latch.countDown();
                    }
                }
            };
            this.bundleContext.addFrameworkListener(refreshListener);
            try {
                this.packageAdmin.refreshPackages(null);
                boolean refreshed = false;
                try {
                    refreshed = latch.await(10L, TimeUnit.SECONDS);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                if (!refreshed) {
                    log.warn("Timeout exceeded waiting for package refresh");
                }
            }
            finally {
                this.bundleContext.removeFrameworkListener(refreshListener);
            }
        }

        public void frameworkEvent(FrameworkEvent event) {
            String bundleBits = "";
            if (event.getBundle() != null) {
                bundleBits = " in bundle " + event.getBundle().getSymbolicName();
            }
            switch (event.getType()) {
                case 2: {
                    log.error("Framework error" + bundleBits, event.getThrowable());
                    break;
                }
                case 16: {
                    log.warn("Framework warning" + bundleBits, event.getThrowable());
                    break;
                }
                case 32: {
                    log.info("Framework info" + bundleBits, event.getThrowable());
                }
            }
        }
    }
}

