/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.osgi.util;

import com.atlassian.fugue.Option;
import com.atlassian.plugin.util.resource.AlternativeResourceLoader;
import com.atlassian.plugin.util.resource.NoOpAlternativeResourceLoader;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import org.apache.commons.collections.iterators.IteratorEnumeration;
import org.osgi.framework.Bundle;

public class BundleClassLoaderAccessor {
    public static ClassLoader getClassLoader(Bundle bundle, AlternativeResourceLoader alternativeResourceLoader) {
        return new BundleClassLoader(bundle, alternativeResourceLoader);
    }

    public static <T> Class<T> loadClass(Bundle bundle, String name) throws ClassNotFoundException {
        Class loadedClass = ((Bundle)Preconditions.checkNotNull((Object)bundle, (Object)"The bundle is required")).loadClass(name);
        return loadedClass;
    }

    private static class BundleClassLoader
    extends ClassLoader {
        private final Bundle bundle;
        private final AlternativeResourceLoader altResourceLoader;

        public BundleClassLoader(Bundle bundle, AlternativeResourceLoader altResourceLoader) {
            super(null);
            this.bundle = (Bundle)Preconditions.checkNotNull((Object)bundle, (Object)"The bundle must not be null");
            this.altResourceLoader = (AlternativeResourceLoader)Option.option((Object)altResourceLoader).getOrElse((Object)new NoOpAlternativeResourceLoader());
        }

        @Override
        public Class<?> findClass(String name) throws ClassNotFoundException {
            return this.bundle.loadClass(name);
        }

        @Override
        public Enumeration<URL> findResources(String name) throws IOException {
            URL resource;
            Enumeration e = this.bundle.getResources(name);
            if (e == null) {
                e = new IteratorEnumeration(Collections.emptyList().iterator());
            } else if (!e.hasMoreElements() && (resource = this.findResource(name)) != null) {
                e = new IteratorEnumeration(Arrays.asList(resource).iterator());
            }
            return e;
        }

        @Override
        public URL findResource(String name) {
            URL url = this.altResourceLoader.getResource(name);
            if (url == null) {
                url = this.bundle.getResource(name);
            }
            return url;
        }
    }
}

