/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.osgi.factory;

import com.atlassian.plugin.ModuleDescriptorFactory;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginArtifact;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.event.PluginEventManager;
import com.atlassian.plugin.factories.AbstractPluginFactory;
import com.atlassian.plugin.impl.UnloadablePlugin;
import com.atlassian.plugin.osgi.container.OsgiContainerException;
import com.atlassian.plugin.osgi.container.OsgiContainerManager;
import com.atlassian.plugin.osgi.factory.OsgiBundlePlugin;
import com.atlassian.plugin.osgi.factory.OsgiPluginXmlDescriptorParserFactory;
import com.atlassian.plugin.osgi.util.OsgiHeaderUtil;
import com.atlassian.plugin.parsers.DescriptorParserFactory;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Ranges;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Set;
import java.util.jar.Manifest;
import org.apache.commons.io.IOUtils;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OsgiBundleFactory
extends AbstractPluginFactory {
    private static final Logger log = LoggerFactory.getLogger(OsgiBundleFactory.class);
    private final OsgiContainerManager osgi;
    private final PluginEventManager pluginEventManager;
    private final String pluginDescriptorFileName;

    public OsgiBundleFactory(OsgiContainerManager osgi, PluginEventManager pluginEventManager) {
        this("atlassian-plugin.xml", osgi, pluginEventManager);
    }

    public OsgiBundleFactory(String pluginDescriptorFileName, OsgiContainerManager osgi, PluginEventManager pluginEventManager) {
        super((DescriptorParserFactory)new OsgiPluginXmlDescriptorParserFactory(), (Set)ImmutableSet.of());
        this.pluginDescriptorFileName = (String)Preconditions.checkNotNull((Object)pluginDescriptorFileName);
        this.osgi = (OsgiContainerManager)Preconditions.checkNotNull((Object)osgi, (Object)"The osgi container is required");
        this.pluginEventManager = (PluginEventManager)Preconditions.checkNotNull((Object)pluginEventManager, (Object)"The plugin event manager is required");
    }

    protected InputStream getDescriptorInputStream(PluginArtifact pluginArtifact) {
        return pluginArtifact.getResourceAsStream(this.pluginDescriptorFileName);
    }

    protected Predicate<Integer> isValidPluginsVersion() {
        return Ranges.atLeast((Comparable)Integer.valueOf(2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String canCreate(PluginArtifact pluginArtifact) throws PluginParseException {
        String string;
        Preconditions.checkNotNull((Object)pluginArtifact, (Object)"The plugin artifact is required");
        InputStream manifestStream = null;
        InputStream descriptorStream = null;
        try {
            Manifest mf;
            String bundleSymbolicName;
            descriptorStream = pluginArtifact.getResourceAsStream(this.pluginDescriptorFileName);
            manifestStream = pluginArtifact.getResourceAsStream("META-INF/MANIFEST.MF");
            String pluginKey = descriptorStream == null && manifestStream != null ? ((bundleSymbolicName = (mf = this.loadManifest(manifestStream)).getMainAttributes().getValue("Bundle-SymbolicName")) == null ? null : OsgiHeaderUtil.getPluginKey(mf)) : null;
            string = pluginKey;
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(manifestStream);
            IOUtils.closeQuietly((InputStream)descriptorStream);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)manifestStream);
        IOUtils.closeQuietly((InputStream)descriptorStream);
        return string;
    }

    private Manifest loadManifest(InputStream manifestStream) {
        try {
            return new Manifest(manifestStream);
        }
        catch (IOException e) {
            throw new PluginParseException("Unable to parse manifest", (Throwable)e);
        }
    }

    public Plugin create(PluginArtifact pluginArtifact, ModuleDescriptorFactory moduleDescriptorFactory) throws PluginParseException {
        Bundle bundle;
        Preconditions.checkNotNull((Object)pluginArtifact, (Object)"The plugin artifact is required");
        Preconditions.checkNotNull((Object)moduleDescriptorFactory, (Object)"The module descriptor factory is required");
        File file = pluginArtifact.toFile();
        boolean allowReference = PluginArtifact.AllowsReference.Default.allowsReference((PluginArtifact)pluginArtifact);
        try {
            bundle = OsgiContainerManager.AllowsReferenceInstall.Default.installBundle(this.osgi, file, allowReference);
        }
        catch (OsgiContainerException ex) {
            return this.reportUnloadablePlugin(file, (Exception)((Object)ex));
        }
        String key = OsgiHeaderUtil.getPluginKey(bundle);
        return new OsgiBundlePlugin(bundle, key, pluginArtifact);
    }

    private Plugin reportUnloadablePlugin(File file, Exception e) {
        log.error("Unable to load plugin: " + file, (Throwable)e);
        UnloadablePlugin plugin = new UnloadablePlugin();
        plugin.setErrorText("Unable to load plugin: " + e.getMessage());
        return plugin;
    }
}

