/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.osgi.factory.transform.stage;

import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.osgi.factory.transform.PluginTransformationException;
import com.atlassian.plugin.osgi.factory.transform.TransformContext;
import com.atlassian.plugin.osgi.factory.transform.TransformStage;
import com.atlassian.plugin.osgi.factory.transform.model.ComponentImport;
import com.atlassian.plugin.osgi.factory.transform.model.SystemExports;
import com.atlassian.plugin.osgi.factory.transform.stage.SpringHelper;
import com.atlassian.plugin.osgi.factory.transform.stage.TransformStageUtils;
import com.atlassian.plugin.osgi.hostcomponents.HostComponentRegistration;
import com.atlassian.plugin.osgi.util.Clazz;
import com.atlassian.plugin.osgi.util.OsgiHeaderUtil;
import com.atlassian.plugin.util.ClassLoaderUtils;
import com.atlassian.plugin.util.PluginUtils;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.IOUtils;
import org.dom4j.Document;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HostComponentSpringStage
implements TransformStage {
    private static final Logger log = LoggerFactory.getLogger(HostComponentSpringStage.class);
    private static final String SPRING_XML = "META-INF/spring/atlassian-plugins-host-components.xml";
    public static final String BEAN_SOURCE = "Host Component";

    @Override
    public void execute(TransformContext context) throws PluginTransformationException {
        block10: {
            if (!SpringHelper.shouldGenerateFile(context, SPRING_XML)) break block10;
            Document doc = SpringHelper.createSpringDocument();
            Set<String> hostComponentInterfaceNames = this.convertRegistrationsToSet(context.getHostComponentRegistrations());
            HashSet<String> matchedInterfaceNames = new HashSet<String>();
            List<String> innerJarPaths = this.findJarPaths(context.getManifest());
            FileInputStream pluginStream = null;
            try {
                pluginStream = new FileInputStream(context.getPluginFile());
                this.findUsedHostComponents(hostComponentInterfaceNames, matchedInterfaceNames, innerJarPaths, pluginStream);
            }
            catch (IOException e) {
                try {
                    throw new PluginParseException("Unable to scan for host components in plugin classes", (Throwable)e);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(pluginStream);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((InputStream)pluginStream);
            ArrayList<HostComponentRegistration> matchedRegistrations = new ArrayList<HostComponentRegistration>();
            Element root = doc.getRootElement();
            if (context.getHostComponentRegistrations() != null) {
                int index = -1;
                for (HostComponentRegistration reg : context.getHostComponentRegistrations()) {
                    ++index;
                    boolean found = false;
                    for (String name : reg.getMainInterfaces()) {
                        if (!matchedInterfaceNames.contains(name) && !this.isRequiredHostComponent(context, name)) continue;
                        found = true;
                    }
                    HashSet<String> regInterfaces = new HashSet<String>(Arrays.asList(reg.getMainInterfaces()));
                    for (ComponentImport compImport : context.getComponentImports().values()) {
                        if (!PluginUtils.doesModuleElementApplyToApplication((Element)compImport.getSource(), context.getApplicationKeys()) || !regInterfaces.containsAll(compImport.getInterfaces())) continue;
                        found = false;
                        break;
                    }
                    if (!found) continue;
                    matchedRegistrations.add(reg);
                    String beanName = reg.getProperties().get("bean-name");
                    Element osgiService = root.addElement("beans:bean");
                    String beanId = this.determineId(context.getComponentImports().keySet(), beanName, index);
                    context.trackBean(beanId, BEAN_SOURCE);
                    osgiService.addAttribute("id", beanId);
                    osgiService.addAttribute("lazy-init", "true");
                    osgiService.addAttribute("class", "com.atlassian.plugin.osgi.bridge.external.HostComponentFactoryBean");
                    context.getExtraImports().add("com.atlassian.plugin.osgi.bridge.external");
                    Element e = osgiService.addElement("beans:property");
                    e.addAttribute("name", "filter");
                    e.addAttribute("value", "(&(bean-name=" + beanName + ")(" + "plugins-host" + "=true))");
                    Element listProp = osgiService.addElement("beans:property");
                    listProp.addAttribute("name", "interfaces");
                    Element list = listProp.addElement("beans:list");
                    for (String inf : reg.getMainInterfaces()) {
                        Element tmp = list.addElement("beans:value");
                        tmp.setText(inf);
                    }
                }
            }
            this.addImportsForMatchedHostComponents(matchedRegistrations, context.getSystemExports(), context.getExtraImports());
            if (root.elements().size() > 0) {
                context.setShouldRequireSpring(true);
                context.getFileOverrides().put(SPRING_XML, SpringHelper.documentToBytes(doc));
            }
        }
    }

    private void addImportsForMatchedHostComponents(List<HostComponentRegistration> matchedRegistrations, SystemExports systemExports, List<String> extraImports) {
        try {
            Set<String> referredPackages = OsgiHeaderUtil.findReferredPackageNames(matchedRegistrations);
            for (String pkg : referredPackages) {
                extraImports.add(systemExports.getFullExport(pkg));
            }
        }
        catch (IOException e) {
            throw new PluginTransformationException("Unable to scan for host component referred packages", e);
        }
    }

    private Set<String> convertRegistrationsToSet(List<HostComponentRegistration> regs) {
        HashSet<String> interfaceNames = new HashSet<String>();
        if (regs != null) {
            for (HostComponentRegistration reg : regs) {
                interfaceNames.addAll(Arrays.asList(reg.getMainInterfaces()));
            }
        }
        return interfaceNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void findUsedHostComponents(Set<String> allHostComponents, Set<String> matchedHostComponents, List<String> innerJarPaths, InputStream jarStream) throws IOException {
        HashSet<String> entries = new HashSet<String>();
        HashSet<String> superClassNames = new HashSet<String>();
        ZipInputStream zin = null;
        try {
            ZipEntry zipEntry;
            zin = new ZipInputStream(new BufferedInputStream(jarStream));
            while ((zipEntry = zin.getNextEntry()) != null) {
                String path = zipEntry.getName();
                if (path.endsWith(".class")) {
                    entries.add(path.substring(0, path.length() - ".class".length()));
                    Clazz cls = new Clazz(path, new BufferedInputStream(new UnclosableFilterInputStream(zin)));
                    superClassNames.add(cls.getSuperClassName());
                    Set referredClasses = cls.getReferredClasses();
                    for (String ref : referredClasses) {
                        String name = TransformStageUtils.jarPathToClassName(ref);
                        if (!allHostComponents.contains(name)) continue;
                        matchedHostComponents.add(name);
                    }
                    continue;
                }
                if (!path.endsWith(".jar") || !innerJarPaths.contains(path)) continue;
                this.findUsedHostComponents(allHostComponents, matchedHostComponents, Collections.<String>emptyList(), new UnclosableFilterInputStream(zin));
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(zin);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)zin);
        this.addHostComponentsUsedInSuperClasses(allHostComponents, matchedHostComponents, entries, superClassNames);
    }

    private void addHostComponentsUsedInSuperClasses(Set<String> allHostComponents, Set<String> matchedHostComponents, Set<String> entries, Set<String> superClassNames) {
        for (String superClassName : superClassNames) {
            Class spr;
            String cls;
            if (entries.contains(superClassName) || (cls = superClassName.replace('/', '.')).startsWith("java.")) continue;
            try {
                spr = ClassLoaderUtils.loadClass((String)cls, this.getClass());
            }
            catch (ClassNotFoundException e) {
                continue;
            }
            for (Method m : spr.getMethods()) {
                for (Class<?> param : m.getParameterTypes()) {
                    if (!allHostComponents.contains(param.getName())) continue;
                    matchedHostComponents.add(param.getName());
                }
            }
        }
    }

    private List<String> findJarPaths(Manifest mf) {
        ArrayList<String> paths = new ArrayList<String>();
        String cp = mf.getMainAttributes().getValue("Bundle-ClassPath");
        if (cp != null) {
            for (String entry : cp.split(",")) {
                if ((entry = entry.trim()).length() != 1 && entry.endsWith(".jar")) {
                    paths.add(entry);
                    continue;
                }
                if (".".equals(entry)) continue;
                log.warn("Non-jar classpath elements not supported: " + entry);
            }
        }
        return paths;
    }

    private String determineId(Set<String> hostComponentNames, String beanName, int iteration) {
        String id = beanName;
        if (id == null) {
            id = "bean" + iteration;
        }
        if (hostComponentNames.contains(id = id.replaceAll("#", "LB"))) {
            id = id + iteration;
        }
        return id;
    }

    private boolean isRequiredHostComponent(TransformContext context, String name) {
        for (HostComponentRegistration registration : context.getRequiredHostComponents()) {
            if (!Arrays.asList(registration.getMainInterfaces()).contains(name)) continue;
            return true;
        }
        return false;
    }

    private static class UnclosableFilterInputStream
    extends FilterInputStream {
        public UnclosableFilterInputStream(InputStream delegate) {
            super(delegate);
        }

        public void close() throws IOException {
        }
    }
}

