/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.osgi.factory;

import com.atlassian.plugin.DefaultModuleDescriptorFactory;
import com.atlassian.plugin.ModuleDescriptorFactory;
import com.atlassian.plugin.descriptors.ChainModuleDescriptorFactory;
import com.atlassian.plugin.hostcontainer.DefaultHostContainer;
import com.atlassian.plugin.hostcontainer.HostContainer;
import com.atlassian.plugin.osgi.external.ListableModuleDescriptorFactory;
import com.atlassian.plugin.osgi.factory.UnrecognisedModuleDescriptorFallbackFactory;
import com.atlassian.plugin.osgi.factory.descriptor.ComponentImportModuleDescriptor;
import com.atlassian.plugin.osgi.factory.descriptor.ComponentModuleDescriptor;
import com.atlassian.plugin.osgi.factory.descriptor.ModuleTypeModuleDescriptor;
import java.util.ArrayList;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OsgiChainedModuleDescriptorFactoryCreator {
    private final ServiceTrackerFactory serviceTrackerFactory;
    private final ModuleDescriptorFactory transformedDescriptorFactory = new DefaultModuleDescriptorFactory((HostContainer)new DefaultHostContainer()){
        {
            this.addModuleDescriptor("component", ComponentModuleDescriptor.class);
            this.addModuleDescriptor("component-import", ComponentImportModuleDescriptor.class);
            this.addModuleDescriptor("module-type", ModuleTypeModuleDescriptor.class);
        }
    };
    private static final Logger log = LoggerFactory.getLogger(OsgiChainedModuleDescriptorFactoryCreator.class);
    private volatile ServiceTracker moduleDescriptorFactoryTracker;

    public OsgiChainedModuleDescriptorFactoryCreator(ServiceTrackerFactory serviceTrackerFactory) {
        this.serviceTrackerFactory = serviceTrackerFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ModuleDescriptorFactory create(ResourceLocator resourceLocator, ModuleDescriptorFactory originalModuleDescriptorFactory) {
        OsgiChainedModuleDescriptorFactoryCreator osgiChainedModuleDescriptorFactoryCreator = this;
        synchronized (osgiChainedModuleDescriptorFactoryCreator) {
            if (this.moduleDescriptorFactoryTracker == null) {
                this.moduleDescriptorFactoryTracker = this.serviceTrackerFactory.create(ModuleDescriptorFactory.class.getName());
            }
        }
        ArrayList<ModuleDescriptorFactory> factories = new ArrayList<ModuleDescriptorFactory>();
        factories.add(this.transformedDescriptorFactory);
        factories.add(originalModuleDescriptorFactory);
        Object[] serviceObjs = this.moduleDescriptorFactoryTracker.getServices();
        if (serviceObjs != null) {
            for (Object fac : serviceObjs) {
                ModuleDescriptorFactory dynFactory = (ModuleDescriptorFactory)fac;
                if (dynFactory instanceof ListableModuleDescriptorFactory) continue;
                factories.add((ModuleDescriptorFactory)fac);
            }
        }
        factories.add(new UnrecognisedModuleDescriptorFallbackFactory());
        return new ChainModuleDescriptorFactory(factories.toArray(new ModuleDescriptorFactory[factories.size()]));
    }

    public static interface ResourceLocator {
        public boolean doesResourceExist(String var1);
    }

    public static interface ServiceTrackerFactory {
        public ServiceTracker create(String var1);
    }
}

