/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.osgi.factory;

import com.atlassian.plugin.DefaultModuleDescriptorFactory;
import com.atlassian.plugin.JarPluginArtifact;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.ModuleDescriptorFactory;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginArtifact;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.descriptors.ChainModuleDescriptorFactory;
import com.atlassian.plugin.event.PluginEventManager;
import com.atlassian.plugin.factories.PluginFactory;
import com.atlassian.plugin.hostcontainer.DefaultHostContainer;
import com.atlassian.plugin.hostcontainer.HostContainer;
import com.atlassian.plugin.impl.UnloadablePlugin;
import com.atlassian.plugin.loaders.classloading.DeploymentUnit;
import com.atlassian.plugin.osgi.container.OsgiContainerManager;
import com.atlassian.plugin.osgi.container.OsgiPersistentCache;
import com.atlassian.plugin.osgi.external.ListableModuleDescriptorFactory;
import com.atlassian.plugin.osgi.factory.OsgiPlugin;
import com.atlassian.plugin.osgi.factory.OsgiPluginXmlDescriptorParserFactory;
import com.atlassian.plugin.osgi.factory.UnrecognisedModuleDescriptorFallbackFactory;
import com.atlassian.plugin.osgi.factory.descriptor.ComponentImportModuleDescriptor;
import com.atlassian.plugin.osgi.factory.descriptor.ComponentModuleDescriptor;
import com.atlassian.plugin.osgi.factory.descriptor.ModuleTypeModuleDescriptor;
import com.atlassian.plugin.osgi.factory.transform.DefaultPluginTransformer;
import com.atlassian.plugin.osgi.factory.transform.PluginTransformationException;
import com.atlassian.plugin.osgi.factory.transform.PluginTransformer;
import com.atlassian.plugin.osgi.factory.transform.model.SystemExports;
import com.atlassian.plugin.parsers.DescriptorParser;
import com.atlassian.plugin.parsers.DescriptorParserFactory;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.Validate;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OsgiPluginFactory
implements PluginFactory {
    private static final Logger log = LoggerFactory.getLogger(OsgiPluginFactory.class);
    private final OsgiContainerManager osgi;
    private final String pluginDescriptorFileName;
    private final DescriptorParserFactory descriptorParserFactory;
    private final PluginEventManager pluginEventManager;
    private final Set<String> applicationKeys;
    private final OsgiPersistentCache persistentCache;
    private final PluginTransformerFactory pluginTransformerFactory;
    private final ModuleDescriptorFactory transformedDescriptorFactory = new DefaultModuleDescriptorFactory((HostContainer)new DefaultHostContainer()){
        {
            this.addModuleDescriptor("component", ComponentModuleDescriptor.class);
            this.addModuleDescriptor("component-import", ComponentImportModuleDescriptor.class);
            this.addModuleDescriptor("module-type", ModuleTypeModuleDescriptor.class);
        }
    };
    private volatile PluginTransformer pluginTransformer;
    private ServiceTracker moduleDescriptorFactoryTracker;

    public OsgiPluginFactory(String pluginDescriptorFileName, String applicationKey, OsgiPersistentCache persistentCache, OsgiContainerManager osgi, PluginEventManager pluginEventManager) {
        this(pluginDescriptorFileName, new HashSet<String>(Arrays.asList(applicationKey)), persistentCache, osgi, pluginEventManager);
    }

    public OsgiPluginFactory(String pluginDescriptorFileName, Set<String> applicationKeys, OsgiPersistentCache persistentCache, OsgiContainerManager osgi, PluginEventManager pluginEventManager) {
        this(pluginDescriptorFileName, applicationKeys, persistentCache, osgi, pluginEventManager, new DefaultPluginTransformerFactory());
    }

    public OsgiPluginFactory(String pluginDescriptorFileName, Set<String> applicationKeys, OsgiPersistentCache persistentCache, OsgiContainerManager osgi, PluginEventManager pluginEventManager, PluginTransformerFactory pluginTransformerFactory) {
        Validate.notNull((Object)pluginDescriptorFileName, (String)"Plugin descriptor is required");
        Validate.notNull((Object)osgi, (String)"The OSGi container is required");
        Validate.notNull(applicationKeys, (String)"The application keys are required");
        Validate.notNull((Object)persistentCache, (String)"The osgi persistent cache is required");
        Validate.notNull((Object)persistentCache, (String)"The plugin event manager is required");
        Validate.notNull((Object)pluginTransformerFactory, (String)"The plugin transformer factory is required");
        this.osgi = osgi;
        this.pluginDescriptorFileName = pluginDescriptorFileName;
        this.descriptorParserFactory = new OsgiPluginXmlDescriptorParserFactory();
        this.pluginEventManager = pluginEventManager;
        this.applicationKeys = applicationKeys;
        this.persistentCache = persistentCache;
        this.pluginTransformerFactory = pluginTransformerFactory;
    }

    private PluginTransformer getPluginTransformer() {
        if (this.pluginTransformer == null) {
            String exportString = (String)this.osgi.getBundles()[0].getHeaders().get("Export-Package");
            SystemExports exports = new SystemExports(exportString);
            this.pluginTransformer = this.pluginTransformerFactory.newPluginTransformer(this.persistentCache, exports, this.applicationKeys, this.pluginDescriptorFileName, this.osgi);
        }
        return this.pluginTransformer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String canCreate(PluginArtifact pluginArtifact) throws PluginParseException {
        Validate.notNull((Object)pluginArtifact, (String)"The plugin artifact is required");
        String pluginKey = null;
        InputStream descriptorStream = null;
        try {
            DescriptorParser descriptorParser;
            descriptorStream = pluginArtifact.getResourceAsStream(this.pluginDescriptorFileName);
            if (descriptorStream != null && (descriptorParser = this.descriptorParserFactory.getInstance(descriptorStream, this.applicationKeys.toArray(new String[this.applicationKeys.size()]))).getPluginsVersion() == 2) {
                pluginKey = descriptorParser.getKey();
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(descriptorStream);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)descriptorStream);
        return pluginKey;
    }

    public Plugin create(DeploymentUnit deploymentUnit, ModuleDescriptorFactory moduleDescriptorFactory) throws PluginParseException {
        Validate.notNull((Object)deploymentUnit, (String)"The deployment unit is required");
        return this.create((PluginArtifact)new JarPluginArtifact(deploymentUnit.getPath()), moduleDescriptorFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Plugin create(PluginArtifact pluginArtifact, ModuleDescriptorFactory moduleDescriptorFactory) throws PluginParseException {
        Validate.notNull((Object)pluginArtifact, (String)"The plugin deployment unit is required");
        Validate.notNull((Object)moduleDescriptorFactory, (String)"The module descriptor factory is required");
        Plugin plugin = null;
        InputStream pluginDescriptor = null;
        try {
            pluginDescriptor = pluginArtifact.getResourceAsStream(this.pluginDescriptorFileName);
            if (pluginDescriptor == null) {
                throw new PluginParseException("No descriptor found in classloader for : " + pluginArtifact);
            }
            ModuleDescriptorFactory combinedFactory = this.getChainedModuleDescriptorFactory(moduleDescriptorFactory, pluginArtifact);
            DescriptorParser parser = this.descriptorParserFactory.getInstance(pluginDescriptor, this.applicationKeys.toArray(new String[this.applicationKeys.size()]));
            OsgiPlugin osgiPlugin = new OsgiPlugin(parser.getKey(), this.osgi, this.createOsgiPluginJar(pluginArtifact), this.pluginEventManager);
            plugin = parser.configurePlugin(combinedFactory, (Plugin)osgiPlugin);
        }
        catch (PluginTransformationException ex) {
            Plugin plugin2;
            try {
                plugin2 = this.reportUnloadablePlugin(pluginArtifact.toFile(), ex);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(pluginDescriptor);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)pluginDescriptor);
            return plugin2;
        }
        IOUtils.closeQuietly((InputStream)pluginDescriptor);
        return plugin;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ModuleDescriptorFactory getChainedModuleDescriptorFactory(ModuleDescriptorFactory originalFactory, PluginArtifact pluginArtifact) {
        OsgiPluginFactory osgiPluginFactory = this;
        synchronized (osgiPluginFactory) {
            if (this.moduleDescriptorFactoryTracker == null) {
                this.moduleDescriptorFactoryTracker = this.osgi.getServiceTracker(ModuleDescriptorFactory.class.getName());
            }
        }
        if (this.moduleDescriptorFactoryTracker != null) {
            ArrayList<ModuleDescriptorFactory> factories = new ArrayList<ModuleDescriptorFactory>();
            factories.add(this.transformedDescriptorFactory);
            factories.add(originalFactory);
            Object[] serviceObjs = this.moduleDescriptorFactoryTracker.getServices();
            if (serviceObjs != null) {
                block3: for (Object fac : serviceObjs) {
                    ModuleDescriptorFactory dynFactory = (ModuleDescriptorFactory)fac;
                    if (dynFactory instanceof ListableModuleDescriptorFactory) {
                        for (Class<ModuleDescriptor<?>> descriptor : ((ListableModuleDescriptorFactory)dynFactory).getModuleDescriptorClasses()) {
                            if (!pluginArtifact.doesResourceExist(descriptor.getName().replace('.', '/') + ".class")) {
                                factories.add((ModuleDescriptorFactory)fac);
                                continue block3;
                            }
                            log.info("Detected a module descriptor - " + descriptor.getName() + " - which is also present in " + "jar to be installed.  Skipping its module descriptor factory.");
                        }
                        continue;
                    }
                    factories.add((ModuleDescriptorFactory)fac);
                }
            }
            factories.add(new UnrecognisedModuleDescriptorFallbackFactory());
            return new ChainModuleDescriptorFactory(factories.toArray(new ModuleDescriptorFactory[factories.size()]));
        }
        return originalFactory;
    }

    private PluginArtifact createOsgiPluginJar(PluginArtifact pluginArtifact) {
        File transformedFile = this.getPluginTransformer().transform(pluginArtifact, this.osgi.getHostComponentRegistrations());
        return new JarPluginArtifact(transformedFile);
    }

    private Plugin reportUnloadablePlugin(File file, Exception e) {
        log.error("Unable to load plugin: " + file, (Throwable)e);
        UnloadablePlugin plugin = new UnloadablePlugin();
        plugin.setErrorText("Unable to load plugin: " + e.getMessage());
        return plugin;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DefaultPluginTransformerFactory
    implements PluginTransformerFactory {
        @Override
        public PluginTransformer newPluginTransformer(OsgiPersistentCache cache, SystemExports systemExports, Set<String> applicationKeys, String pluginDescriptorPath, OsgiContainerManager osgi) {
            return new DefaultPluginTransformer(cache, systemExports, applicationKeys, pluginDescriptorPath, osgi);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface PluginTransformerFactory {
        public PluginTransformer newPluginTransformer(OsgiPersistentCache var1, SystemExports var2, Set<String> var3, String var4, OsgiContainerManager var5);
    }
}

