/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.osgi.util;

import aQute.lib.header.OSGiHeader;
import com.atlassian.plugin.osgi.hostcomponents.HostComponentRegistration;
import com.atlassian.plugin.osgi.util.Clazz;
import com.atlassian.plugin.util.ClassLoaderUtils;
import com.atlassian.plugin.util.ClassUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.Manifest;
import org.apache.commons.io.IOUtils;
import org.osgi.framework.Bundle;
import org.osgi.framework.Version;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OsgiHeaderUtil {
    static final String JDK_PACKAGES_PATH = "jdk-packages.txt";
    static final String JDK6_PACKAGES_PATH = "jdk6-packages.txt";
    static Logger log = LoggerFactory.getLogger(OsgiHeaderUtil.class);

    public static String findReferredPackages(List<HostComponentRegistration> registrations) throws IOException {
        return OsgiHeaderUtil.findReferredPackages(registrations, Collections.<String, String>emptyMap());
    }

    public static String findReferredPackages(List<HostComponentRegistration> registrations, Map<String, String> packageVersions) throws IOException {
        StringBuffer sb = new StringBuffer();
        HashSet<String> referredPackages = new HashSet<String>();
        HashSet<String> referredClasses = new HashSet<String>();
        if (registrations == null) {
            sb.append(",");
        } else {
            for (HostComponentRegistration reg : registrations) {
                HashSet classesToScan = new HashSet();
                for (Class<?> inf : reg.getMainInterfaceClasses()) {
                    ClassUtils.findAllTypes(inf, classesToScan);
                }
                for (Class inf : classesToScan) {
                    String clsName = inf.getName().replace('.', '/') + ".class";
                    OsgiHeaderUtil.crawlReferenceTree(clsName, referredClasses, referredPackages, 1);
                }
            }
            for (String pkg : referredPackages) {
                String version = packageVersions.get(pkg);
                sb.append(pkg);
                if (version != null) {
                    try {
                        Version.parseVersion((String)version);
                        sb.append(";version=").append(version);
                    }
                    catch (IllegalArgumentException ex) {
                        log.info("Unable to parse version: " + version);
                    }
                }
                sb.append(",");
            }
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void crawlReferenceTree(String className, Set<String> scannedClasses, Set<String> packageImports, int level) throws IOException {
        if (level <= 0) {
            return;
        }
        if (className.startsWith("java/")) {
            return;
        }
        if (scannedClasses.contains(className)) {
            return;
        }
        scannedClasses.add(className);
        if (log.isDebugEnabled()) {
            log.debug("Crawling " + className);
        }
        InputStream in = null;
        try {
            in = ClassLoaderUtils.getResourceAsStream((String)className, OsgiHeaderUtil.class);
            if (in == null) {
                log.error("Cannot find interface " + className);
                return;
            }
            Clazz clz = new Clazz(className, in);
            packageImports.addAll(clz.getReferred().keySet());
            Set referredClasses = clz.getReferredClasses();
            for (String ref : referredClasses) {
                OsgiHeaderUtil.crawlReferenceTree(ref, scannedClasses, packageImports, level - 1);
            }
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
        }
    }

    public static Map<String, Map<String, String>> parseHeader(String header) {
        return OSGiHeader.parseHeader((String)header);
    }

    public static String buildHeader(Map<String, Map<String, String>> values) {
        StringBuilder header = new StringBuilder();
        Iterator<Map.Entry<String, Map<String, String>>> i = values.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry<String, Map<String, String>> entry = i.next();
            OsgiHeaderUtil.buildHeader(entry.getKey(), entry.getValue(), header);
            if (!i.hasNext()) continue;
            header.append(",");
        }
        return header.toString();
    }

    public static String buildHeader(String key, Map<String, String> attrs) {
        StringBuilder fullPkg = new StringBuilder();
        OsgiHeaderUtil.buildHeader(key, attrs, fullPkg);
        return fullPkg.toString();
    }

    private static void buildHeader(String key, Map<String, String> attrs, StringBuilder builder) {
        builder.append(key);
        if (attrs != null && !attrs.isEmpty()) {
            for (Map.Entry<String, String> entry : attrs.entrySet()) {
                builder.append(";");
                builder.append(entry.getKey());
                builder.append("=\"");
                builder.append(entry.getValue());
                builder.append("\"");
            }
        }
    }

    public static String getPluginKey(Bundle bundle) {
        return OsgiHeaderUtil.getPluginKey(bundle.getSymbolicName(), bundle.getHeaders().get("Atlassian-Plugin-Key"), bundle.getHeaders().get("Bundle-Version"));
    }

    public static String getPluginKey(Manifest mf) {
        return OsgiHeaderUtil.getPluginKey(mf.getMainAttributes().getValue("Bundle-SymbolicName"), mf.getMainAttributes().getValue("Atlassian-Plugin-Key"), mf.getMainAttributes().getValue("Bundle-Version"));
    }

    private static String getPluginKey(Object bundleName, Object atlKey, Object version) {
        Object key = atlKey;
        if (key == null) {
            key = bundleName + "-" + version;
        }
        return key.toString();
    }
}

