/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.osgi.factory;

import com.atlassian.plugin.AutowireCapablePlugin;
import com.atlassian.plugin.IllegalPluginStateException;
import com.atlassian.plugin.module.ContainerAccessor;
import com.atlassian.plugin.osgi.container.OsgiContainerException;
import com.atlassian.plugin.osgi.factory.OsgiPluginHelper;
import com.atlassian.plugin.osgi.spring.DefaultSpringContainerAccessor;
import com.atlassian.plugin.osgi.spring.SpringContainerAccessor;
import com.atlassian.plugin.osgi.util.BundleClassLoaderAccessor;
import com.atlassian.plugin.osgi.util.OsgiHeaderUtil;
import com.atlassian.plugin.util.resource.AlternativeDirectoryResourceLoader;
import com.atlassian.plugin.util.resource.AlternativeResourceLoader;
import java.io.InputStream;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.Validate;
import org.osgi.framework.Bundle;
import org.osgi.service.packageadmin.ExportedPackage;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.util.tracker.ServiceTracker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class OsgiPluginInstalledHelper
implements OsgiPluginHelper {
    private final ClassLoader bundleClassLoader;
    private final Bundle bundle;
    private final PackageAdmin packageAdmin;
    private volatile SpringContainerAccessor containerAccessor;
    private volatile ServiceTracker[] serviceTrackers;

    public OsgiPluginInstalledHelper(Bundle bundle, PackageAdmin packageAdmin) {
        Validate.notNull((Object)bundle);
        Validate.notNull((Object)packageAdmin);
        this.bundle = bundle;
        this.bundleClassLoader = BundleClassLoaderAccessor.getClassLoader(bundle, (AlternativeResourceLoader)new AlternativeDirectoryResourceLoader());
        this.packageAdmin = packageAdmin;
    }

    @Override
    public Bundle getBundle() {
        return this.bundle;
    }

    @Override
    public <T> Class<T> loadClass(String clazz, Class<?> callingClass) throws ClassNotFoundException {
        return BundleClassLoaderAccessor.loadClass(this.getBundle(), clazz);
    }

    @Override
    public URL getResource(String name) {
        return this.bundleClassLoader.getResource(name);
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        return this.bundleClassLoader.getResourceAsStream(name);
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.bundleClassLoader;
    }

    @Override
    public Bundle install() {
        throw new IllegalPluginStateException("Plugin '" + this.bundle.getSymbolicName() + "' has already been installed");
    }

    @Override
    public void onEnable(ServiceTracker ... serviceTrackers) throws OsgiContainerException {
        Validate.notNull((Object)serviceTrackers);
        for (ServiceTracker svc : serviceTrackers) {
            svc.open();
        }
        this.serviceTrackers = serviceTrackers;
    }

    @Override
    public void onDisable() throws OsgiContainerException {
        ServiceTracker[] serviceTrackers = this.serviceTrackers;
        if (serviceTrackers != null) {
            for (ServiceTracker svc : serviceTrackers) {
                svc.close();
            }
            this.serviceTrackers = null;
        }
        this.setPluginContainer(null);
    }

    @Override
    public void onUninstall() throws OsgiContainerException {
    }

    @Override
    public <T> T autowire(Class<T> clazz, AutowireCapablePlugin.AutowireStrategy autowireStrategy) throws IllegalPluginStateException {
        this.assertSpringContextAvailable();
        return (T)this.containerAccessor.createBean(clazz);
    }

    @Override
    public void autowire(Object instance, AutowireCapablePlugin.AutowireStrategy autowireStrategy) throws IllegalPluginStateException {
        this.assertSpringContextAvailable();
        this.containerAccessor.autowireBean(instance, autowireStrategy);
    }

    @Override
    public Set<String> getRequiredPlugins() {
        HashSet<String> keys = new HashSet<String>();
        this.getRequiredPluginsFromExports(keys);
        return keys;
    }

    private void getRequiredPluginsFromExports(Set<String> keys) {
        Set<String> imports = OsgiHeaderUtil.parseHeader((String)this.getBundle().getHeaders().get("Import-Package")).keySet();
        for (String imp : imports) {
            ExportedPackage[] exports = this.packageAdmin.getExportedPackages(imp);
            if (exports == null) continue;
            block1: for (ExportedPackage export : exports) {
                Bundle[] importingBundles = export.getImportingBundles();
                if (importingBundles == null) continue;
                for (Bundle importingBundle : importingBundles) {
                    if (this.getBundle() != importingBundle) continue;
                    keys.add(OsgiHeaderUtil.getPluginKey(export.getExportingBundle()));
                    continue block1;
                }
            }
        }
    }

    @Override
    public void setPluginContainer(Object container) {
        this.containerAccessor = container == null ? null : new DefaultSpringContainerAccessor(container);
    }

    @Override
    public ContainerAccessor getContainerAccessor() {
        return this.containerAccessor;
    }

    private void assertSpringContextAvailable() throws IllegalPluginStateException {
        if (this.containerAccessor == null) {
            throw new IllegalStateException("Cannot autowire object because the Spring context is unavailable.  Ensure your OSGi bundle contains the 'Spring-Context' header.");
        }
    }
}

