/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.osgi.factory;

import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.PluginException;
import com.atlassian.plugin.PluginInformation;
import com.atlassian.plugin.PluginState;
import com.atlassian.plugin.Resourced;
import com.atlassian.plugin.elements.ResourceDescriptor;
import com.atlassian.plugin.elements.ResourceLocation;
import com.atlassian.plugin.event.PluginEventManager;
import com.atlassian.plugin.impl.AbstractPlugin;
import com.atlassian.plugin.osgi.util.BundleClassLoaderAccessor;
import com.atlassian.plugin.util.resource.AlternativeDirectoryResourceLoader;
import com.atlassian.plugin.util.resource.AlternativeResourceLoader;
import java.io.InputStream;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OsgiBundlePlugin
extends AbstractPlugin {
    private final Bundle bundle;
    private final PluginInformation pluginInformation;
    private final Date dateLoaded;
    private final String key;
    private final ClassLoader bundleClassLoader;

    public OsgiBundlePlugin(Bundle bundle, String key, PluginEventManager pluginEventManager) {
        this.bundleClassLoader = BundleClassLoaderAccessor.getClassLoader(bundle, (AlternativeResourceLoader)new AlternativeDirectoryResourceLoader());
        this.bundle = bundle;
        this.pluginInformation = new PluginInformation();
        this.pluginInformation.setDescription((String)bundle.getHeaders().get("Bundle-Description"));
        this.pluginInformation.setVersion((String)bundle.getHeaders().get("Bundle-Version"));
        this.pluginInformation.setVendorName((String)bundle.getHeaders().get("Bundle-Vendor"));
        this.key = key;
        this.dateLoaded = new Date();
    }

    public int getPluginsVersion() {
        return 2;
    }

    public void setPluginsVersion(int version) {
        throw new UnsupportedOperationException("Not available");
    }

    public String getName() {
        return (String)this.bundle.getHeaders().get("Bundle-Name");
    }

    public void setName(String name) {
        throw new UnsupportedOperationException("Not available");
    }

    public void setI18nNameKey(String i18nNameKey) {
        throw new UnsupportedOperationException("Not available");
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String aPackage) {
        throw new UnsupportedOperationException("Not available");
    }

    public void addModuleDescriptor(ModuleDescriptor<?> moduleDescriptor) {
        throw new UnsupportedOperationException("Not available");
    }

    public Collection<ModuleDescriptor<?>> getModuleDescriptors() {
        return Collections.emptyList();
    }

    public ModuleDescriptor<?> getModuleDescriptor(String key) {
        return null;
    }

    public <M> List<ModuleDescriptor<M>> getModuleDescriptorsByModuleClass(Class<M> aClass) {
        return Collections.emptyList();
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    public void setEnabledByDefault(boolean enabledByDefault) {
        throw new UnsupportedOperationException("Not available");
    }

    public PluginInformation getPluginInformation() {
        return this.pluginInformation;
    }

    public void setPluginInformation(PluginInformation pluginInformation) {
        throw new UnsupportedOperationException("Not available");
    }

    public void setResources(Resourced resources) {
        throw new UnsupportedOperationException("Not available");
    }

    public boolean isSystemPlugin() {
        return false;
    }

    public boolean containsSystemModule() {
        return false;
    }

    public void setSystemPlugin(boolean system) {
        throw new UnsupportedOperationException("Not available");
    }

    public Date getDateLoaded() {
        return this.dateLoaded;
    }

    public boolean isUninstallable() {
        return true;
    }

    public boolean isDeleteable() {
        return true;
    }

    public boolean isDynamicallyLoaded() {
        return true;
    }

    public List<ResourceDescriptor> getResourceDescriptors() {
        return Collections.emptyList();
    }

    public List<ResourceDescriptor> getResourceDescriptors(String type) {
        return Collections.emptyList();
    }

    public ResourceLocation getResourceLocation(String type, String name) {
        return null;
    }

    public ResourceDescriptor getResourceDescriptor(String type, String name) {
        return null;
    }

    public <T> Class<T> loadClass(String clazz, Class<?> callingClass) throws ClassNotFoundException {
        return BundleClassLoaderAccessor.loadClass(this.bundle, clazz);
    }

    public URL getResource(String name) {
        return this.bundleClassLoader.getResource(name);
    }

    public InputStream getResourceAsStream(String name) {
        return this.bundleClassLoader.getResourceAsStream(name);
    }

    protected void uninstallInternal() {
        try {
            this.bundle.uninstall();
        }
        catch (BundleException e) {
            throw new PluginException((Throwable)e);
        }
    }

    protected PluginState enableInternal() {
        try {
            this.bundle.start();
            return PluginState.ENABLED;
        }
        catch (BundleException e) {
            throw new PluginException((Throwable)e);
        }
    }

    protected void disableInternal() {
        try {
            if (this.bundle.getState() == 32) {
                this.bundle.stop();
            }
        }
        catch (BundleException e) {
            throw new PluginException((Throwable)e);
        }
    }

    public ClassLoader getClassLoader() {
        return this.bundleClassLoader;
    }
}

