/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.osgi.factory.transform;

import com.atlassian.plugin.PluginArtifact;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.osgi.factory.transform.PluginTransformationException;
import com.atlassian.plugin.osgi.factory.transform.model.ComponentImport;
import com.atlassian.plugin.osgi.factory.transform.model.SystemExports;
import com.atlassian.plugin.osgi.hostcomponents.HostComponentRegistration;
import com.atlassian.plugin.parsers.XmlDescriptorParser;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.Validate;
import org.dom4j.Document;
import org.dom4j.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransformContext {
    private final Manifest manifest;
    private final List<HostComponentRegistration> regs;
    private final Map<String, byte[]> fileOverrides;
    private final Map<String, String> bndInstructions;
    private final Document descriptorDocument;
    private final List<String> extraImports;
    private final List<String> extraExports;
    private final PluginArtifact pluginArtifact;
    private final Map<String, ComponentImport> componentImports;
    private final SystemExports systemExports;
    private final Set<String> applicationKeys;
    private boolean shouldRequireSpring = false;

    public TransformContext(List<HostComponentRegistration> regs, SystemExports systemExports, PluginArtifact pluginArtifact, Set<String> applicationKeys, String descriptorPath) {
        Validate.notNull((Object)pluginArtifact, (String)"The plugin artifact must be specified");
        Validate.notNull((Object)descriptorPath, (String)"The plugin descriptor path must be specified");
        Validate.notNull((Object)systemExports, (String)"The system exports must be specified");
        this.regs = regs;
        this.systemExports = systemExports;
        this.pluginArtifact = pluginArtifact;
        this.applicationKeys = applicationKeys == null ? Collections.emptySet() : applicationKeys;
        JarFile jarFile = null;
        try {
            jarFile = new JarFile(pluginArtifact.toFile());
            this.manifest = jarFile.getManifest();
            this.closeJarQuietly(jarFile);
        }
        catch (IOException e) {
            try {
                throw new IllegalArgumentException("File must be a jar", e);
            }
            catch (Throwable throwable) {
                this.closeJarQuietly(jarFile);
                throw throwable;
            }
        }
        this.fileOverrides = new HashMap<String, byte[]>();
        this.bndInstructions = new HashMap<String, String>();
        this.descriptorDocument = this.retrieveDocFromJar(pluginArtifact, descriptorPath);
        this.extraImports = new ArrayList<String>();
        this.extraExports = new ArrayList<String>();
        this.componentImports = Collections.unmodifiableMap(this.parseComponentImports(this.descriptorDocument));
    }

    private Map<String, ComponentImport> parseComponentImports(Document descriptorDocument) {
        HashMap<String, ComponentImport> componentImports = new HashMap<String, ComponentImport>();
        List elements = descriptorDocument.getRootElement().elements("component-import");
        for (Element component : elements) {
            ComponentImport ci = new ComponentImport(component);
            componentImports.put(ci.getKey(), ci);
        }
        return componentImports;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Document retrieveDocFromJar(PluginArtifact pluginArtifact, String descriptorPath) throws PluginTransformationException {
        Document document;
        InputStream stream = null;
        try {
            stream = pluginArtifact.getResourceAsStream(descriptorPath);
            if (stream == null) {
                throw new PluginTransformationException("Unable to access descriptor " + descriptorPath);
            }
            DocumentExposingDescriptorParser parser = new DocumentExposingDescriptorParser(stream);
            document = parser.getDocument();
        }
        finally {
            IOUtils.closeQuietly((InputStream)stream);
        }
        return document;
    }

    public File getPluginFile() {
        return this.pluginArtifact.toFile();
    }

    public PluginArtifact getPluginArtifact() {
        return this.pluginArtifact;
    }

    public List<HostComponentRegistration> getHostComponentRegistrations() {
        return this.regs;
    }

    public Map<String, byte[]> getFileOverrides() {
        return this.fileOverrides;
    }

    public Map<String, String> getBndInstructions() {
        return this.bndInstructions;
    }

    public Document getDescriptorDocument() {
        return this.descriptorDocument;
    }

    public Manifest getManifest() {
        return this.manifest;
    }

    public List<String> getExtraImports() {
        return this.extraImports;
    }

    public List<String> getExtraExports() {
        return this.extraExports;
    }

    public Map<String, ComponentImport> getComponentImports() {
        return this.componentImports;
    }

    public SystemExports getSystemExports() {
        return this.systemExports;
    }

    public Set<String> getApplicationKeys() {
        return this.applicationKeys;
    }

    public boolean shouldRequireSpring() {
        return this.shouldRequireSpring;
    }

    public void setShouldRequireSpring(boolean shouldRequireSpring) {
        this.shouldRequireSpring = shouldRequireSpring;
        if (shouldRequireSpring) {
            this.getFileOverrides().put("META-INF/spring/", new byte[0]);
        }
    }

    public List<JarEntry> getPluginJarEntries() {
        ArrayList<JarEntry> list = new ArrayList<JarEntry>();
        JarFile jarFile = null;
        try {
            Enumeration<JarEntry> entries;
            jarFile = new JarFile(this.pluginArtifact.toFile());
            Enumeration<JarEntry> e = entries = jarFile.entries();
            while (e.hasMoreElements()) {
                JarEntry entry = e.nextElement();
                list.add(entry);
            }
            ArrayList<JarEntry> arrayList = list;
            this.closeJarQuietly(jarFile);
            return arrayList;
        }
        catch (IOException e) {
            try {
                throw new IllegalArgumentException("File must be a jar", e);
            }
            catch (Throwable throwable) {
                this.closeJarQuietly(jarFile);
                throw throwable;
            }
        }
    }

    public Object getPluginJarEntry(String path) {
        JarFile jarFile = null;
        try {
            jarFile = new JarFile(this.pluginArtifact.toFile());
            ZipEntry zipEntry = jarFile.getEntry(path);
            this.closeJarQuietly(jarFile);
            return zipEntry;
        }
        catch (IOException e) {
            try {
                throw new IllegalArgumentException("File must be a jar", e);
            }
            catch (Throwable throwable) {
                this.closeJarQuietly(jarFile);
                throw throwable;
            }
        }
    }

    private void closeJarQuietly(JarFile jarFile) {
        if (jarFile != null) {
            try {
                jarFile.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static class DocumentExposingDescriptorParser
    extends XmlDescriptorParser {
        public DocumentExposingDescriptorParser(InputStream source) throws PluginParseException {
            super(source, null);
        }

        public Document getDocument() {
            return super.getDocument();
        }
    }
}

