/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.osgi.container.felix;

import aQute.lib.osgi.Analyzer;
import aQute.lib.osgi.Jar;
import com.atlassian.plugin.osgi.container.PackageScannerConfiguration;
import com.atlassian.plugin.osgi.hostcomponents.HostComponentRegistration;
import com.atlassian.plugin.osgi.util.OsgiHeaderUtil;
import com.atlassian.plugin.util.ClassLoaderUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.jar.Manifest;
import javax.servlet.ServletContext;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.Version;
import org.twdata.pkgscanner.ExportPackage;
import org.twdata.pkgscanner.PackageScanner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ExportsBuilder {
    static final String JDK_PACKAGES_PATH = "jdk-packages.txt";
    static final String JDK6_PACKAGES_PATH = "jdk6-packages.txt";
    private static Log log = LogFactory.getLog(ExportsBuilder.class);
    private static final String EXPORTS_TXT = "exports.txt";

    ExportsBuilder() {
    }

    public String determineExports(List<HostComponentRegistration> regs, PackageScannerConfiguration packageScannerConfig, File cacheDir) {
        String exports = null;
        StringBuilder origExports = new StringBuilder();
        origExports.append("org.osgi.framework; version=1.4.1,");
        origExports.append("org.osgi.service.packageadmin; version=1.2.0,");
        origExports.append("org.osgi.service.startlevel; version=1.1.0,");
        origExports.append("org.osgi.service.url; version=1.0.0,");
        origExports.append("org.osgi.util; version=1.4.1,");
        origExports.append("org.osgi.util.tracker; version=1.4.1,");
        origExports.append("host.service.command; version=1.0.0,");
        this.constructJdkExports(origExports, JDK_PACKAGES_PATH);
        origExports.append(",");
        if (System.getProperty("java.specification.version").equals("1.6")) {
            this.constructJdkExports(origExports, JDK6_PACKAGES_PATH);
            origExports.append(",");
        }
        Collection<ExportPackage> exportList = this.generateExports(packageScannerConfig);
        this.constructAutoExports(origExports, exportList);
        try {
            origExports.append(OsgiHeaderUtil.findReferredPackages(regs));
            Analyzer analyzer = new Analyzer();
            analyzer.setJar(new Jar("somename.jar"));
            analyzer.setProperty("Import-Package", origExports.toString());
            Manifest mf = analyzer.calcManifest();
            exports = mf.getMainAttributes().getValue("Import-Package");
        }
        catch (IOException ex) {
            log.error((Object)"Unable to calculate necessary exports based on host components", (Throwable)ex);
            exports = origExports.toString();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Exports:\n" + exports.replaceAll(",", "\r\n")));
        }
        return exports;
    }

    void constructAutoExports(StringBuilder sb, Collection<ExportPackage> packageExports) {
        for (ExportPackage pkg : packageExports) {
            sb.append(pkg.getPackageName());
            if (pkg.getVersion() != null) {
                try {
                    Version.parseVersion((String)pkg.getVersion());
                    sb.append(";version=").append(pkg.getVersion());
                }
                catch (IllegalArgumentException ex) {
                    log.info((Object)("Unable to parse version: " + pkg.getVersion()));
                }
            }
            sb.append(",");
        }
    }

    Collection<ExportPackage> generateExports(PackageScannerConfiguration packageScannerConfig) {
        Collection exports;
        String[] arrType = new String[]{};
        PackageScanner scanner = new PackageScanner().select(PackageScanner.jars((String[])PackageScanner.include((String[])packageScannerConfig.getJarIncludes().toArray(arrType)), (String[])PackageScanner.exclude((String[])packageScannerConfig.getJarExcludes().toArray(arrType))), PackageScanner.packages((String[])PackageScanner.include((String[])packageScannerConfig.getPackageIncludes().toArray(arrType)), (String[])PackageScanner.exclude((String[])packageScannerConfig.getPackageExcludes().toArray(arrType)))).withMappings(packageScannerConfig.getPackageVersions());
        if (log.isDebugEnabled()) {
            scanner.enableDebug();
        }
        if (!ExportsBuilder.isPackageScanSuccessful(exports = scanner.scan()) && packageScannerConfig.getServletContext() != null) {
            log.warn((Object)"Unable to find expected packages via classloader scanning.  Trying ServletContext scanning...");
            ServletContext ctx = packageScannerConfig.getServletContext();
            try {
                exports = scanner.scan(new URL[]{ctx.getResource("/WEB-INF/lib"), ctx.getResource("/WEB-INF/classes")});
            }
            catch (MalformedURLException e) {
                log.warn((Object)e);
            }
        }
        if (!ExportsBuilder.isPackageScanSuccessful(exports)) {
            throw new IllegalStateException("Unable to find required packages via classloader or servlet context scanning, most likely due to an application server bug.");
        }
        return exports;
    }

    private static boolean isPackageScanSuccessful(Collection<ExportPackage> exports) {
        boolean log4jFound = false;
        for (ExportPackage export : exports) {
            if (!export.getPackageName().equals("org.apache.log4j")) continue;
            log4jFound = true;
            break;
        }
        return log4jFound;
    }

    void constructJdkExports(StringBuilder sb, String packageListPath) {
        InputStream in = null;
        try {
            String line;
            in = ClassLoaderUtils.getResourceAsStream((String)packageListPath, ExportsBuilder.class);
            BufferedReader reader = new BufferedReader(new InputStreamReader(in));
            while ((line = reader.readLine()) != null) {
                if ((line = line.trim()).length() <= 0 || line.charAt(0) == '#') continue;
                if (sb.length() > 0) {
                    sb.append(',');
                }
                sb.append(line);
            }
        }
        catch (IOException e) {
            IOUtils.closeQuietly((InputStream)in);
        }
    }
}

