/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.osgi.factory.transform.stage;

import com.atlassian.plugin.osgi.factory.transform.PluginTransformationException;
import com.atlassian.plugin.osgi.factory.transform.TransformContext;
import com.atlassian.plugin.osgi.factory.transform.TransformStage;
import com.atlassian.plugin.osgi.factory.transform.model.ComponentImport;
import com.atlassian.plugin.osgi.factory.transform.stage.SpringHelper;
import com.atlassian.plugin.util.PluginUtils;
import org.dom4j.Document;
import org.dom4j.Element;

public class ComponentImportSpringStage
implements TransformStage {
    private static final String SPRING_XML = "META-INF/spring/atlassian-plugins-component-imports.xml";

    public void execute(TransformContext context) throws PluginTransformationException {
        if (SpringHelper.shouldGenerateFile(context, SPRING_XML)) {
            Document springDoc = SpringHelper.createSpringDocument();
            Element root = springDoc.getRootElement();
            for (ComponentImport comp : context.getComponentImports().values()) {
                if (!PluginUtils.doesModuleElementApplyToApplication((Element)comp.getSource(), context.getApplicationKeys())) continue;
                Element osgiReference = root.addElement("osgi:reference");
                osgiReference.addAttribute("id", comp.getKey());
                Element interfaces = osgiReference.addElement("osgi:interfaces");
                for (String infName : comp.getInterfaces()) {
                    context.getExtraImports().add(infName.substring(0, infName.lastIndexOf(46)));
                    Element e = interfaces.addElement("beans:value");
                    e.setText(infName);
                }
            }
            if (root.elements().size() > 0) {
                context.setShouldRequireSpring(true);
                context.getFileOverrides().put(SPRING_XML, SpringHelper.documentToBytes(springDoc));
            }
        }
    }
}

