/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.osgi.test.rest;

import com.atlassian.plugin.util.ClassLoaderStack;
import com.atlassian.plugins.osgi.test.BundleTestClassesManager;
import com.atlassian.plugins.osgi.test.JUnitOSGiTestExecutor;
import com.atlassian.plugins.osgi.test.OsgiTestClassLoader;
import com.atlassian.plugins.osgi.test.rest.BundleResultRepresentation;
import com.atlassian.plugins.osgi.test.rest.BundleTestListRepresentation;
import com.atlassian.plugins.osgi.test.rest.GsonFactory;
import com.atlassian.plugins.osgi.test.rest.TestDetailRepresentation;
import com.atlassian.plugins.osgi.test.rest.TestResultDetailRepresentation;
import com.atlassian.plugins.osgi.test.util.Pair;
import com.atlassian.plugins.osgi.test.util.TestClassUtils;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.google.gson.Gson;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import junit.framework.TestCase;
import org.junit.internal.runners.JUnit38ClassRunner;
import org.junit.runner.Description;
import org.junit.runner.JUnitCore;
import org.junit.runner.Request;
import org.junit.runner.Result;
import org.junit.runner.Runner;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.InitializationError;

@Path(value="/")
public class TestRunnerResource {
    private final Gson gson = GsonFactory.getGson();
    private OsgiTestClassLoader testLoader;

    public TestRunnerResource(OsgiTestClassLoader testLoader) {
        this.testLoader = testLoader;
    }

    @GET
    @Path(value="runtest/{testClassName}")
    @AnonymousAllowed
    @Produces(value={"application/json"})
    public Response runTest(@PathParam(value="testClassName") String testClassName) {
        TestResultDetailRepresentation result = this.executeTest(testClassName).getResult();
        String json = this.gson.toJson((Object)result);
        return Response.ok((Object)json, (String)"application/json").build();
    }

    @GET
    @Path(value="runtestfromconsole/{testClassName}")
    @AnonymousAllowed
    @Produces(value={"application/json"})
    public Response runTestFromConsole(@PathParam(value="testClassName") String testClassName) {
        BundleResultAndTestClass resultAndClass = this.executeTest(testClassName);
        String bundleSymbolicName = resultAndClass.getBundleSymbolicName();
        TestResultDetailRepresentation testResultDetail = resultAndClass.getResult();
        BundleResultRepresentation bundleResult = new BundleResultRepresentation(bundleSymbolicName, testResultDetail);
        String json = this.gson.toJson((Object)bundleResult);
        return Response.ok((Object)json, (String)"application/json").build();
    }

    @GET
    @Path(value="testlist/{bundleSymbolicName}")
    @AnonymousAllowed
    @Produces(value={"application/json"})
    public Response testList(@PathParam(value="bundleSymbolicName") String bundleSymbolicName) {
        List<Object> osgiTests = this.testLoader.findAllTestsForBundle(bundleSymbolicName);
        BundleTestListRepresentation bundleList = new BundleTestListRepresentation(bundleSymbolicName);
        List<TestDetailRepresentation> wiredTestHolders = bundleList.getWiredTests();
        List<TestDetailRepresentation> unitTestHolders = bundleList.getUnitTests();
        List<TestDetailRepresentation> itTestHolders = bundleList.getITTests();
        TestDetailComparator comparator = new TestDetailComparator();
        for (Object object : osgiTests) {
            this.loadTestDetails(object.getClass(), wiredTestHolders);
        }
        Set<Class<?>> unitClasses = BundleTestClassesManager.instance().getUnitTests(bundleSymbolicName);
        for (Class<?> clazz : unitClasses) {
            this.loadTestDetails(clazz, unitTestHolders);
        }
        Set<Class<?>> set = BundleTestClassesManager.instance().getIntegrationTests(bundleSymbolicName);
        for (Class<?> clazz : set) {
            this.loadTestDetails(clazz, itTestHolders);
        }
        Collections.sort(wiredTestHolders, comparator);
        Collections.sort(unitTestHolders, comparator);
        Collections.sort(itTestHolders, comparator);
        String string = this.gson.toJson((Object)bundleList);
        Response rsp = Response.ok((Object)string, (String)"application/json").build();
        return rsp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BundleResultAndTestClass executeTest(String testClassName) {
        Class testClass = null;
        String bundleSymbolicName = "";
        Result testResult = new Result();
        TestResultDetailRepresentation resultDetail = new TestResultDetailRepresentation(testClassName, testResult);
        try {
            Pair<Runner, Pair<String, Class>> runnerAndTest = this.getRunnerAndTest(testClassName);
            Runner runner = runnerAndTest.first();
            bundleSymbolicName = runnerAndTest.second().first();
            testClass = runnerAndTest.second().second();
            JUnitCore c = new JUnitCore();
            try {
                ClassLoaderStack.push((ClassLoader)testClass.getClassLoader());
                testResult = c.run(Request.runner((Runner)runner));
            }
            finally {
                ClassLoaderStack.pop();
            }
            for (Failure f : testResult.getFailures()) {
                f.getException().getStackTrace();
                f.getException().printStackTrace();
                resultDetail.getFailedMethods().put(f.getDescription().getMethodName(), f);
            }
            if (null == testClass) {
                Description desc = Description.createSuiteDescription((String)testClassName, (Annotation[])new Annotation[0]);
                Failure classNotFoundFail = new Failure(desc, (Throwable)new ClassNotFoundException("Unable to find class for test [" + testClassName + "]"));
                resultDetail.getFailedMethods().put(testClassName, classNotFoundFail);
            }
            if (JUnitOSGiTestExecutor.class.isAssignableFrom(runner.getClass())) {
                JUnitOSGiTestExecutor osgiRunner = (JUnitOSGiTestExecutor)runner;
                resultDetail.getIgnoredMethods().addAll(osgiRunner.getIgnoredMethodNames());
                resultDetail.getPassedMethods().addAll(osgiRunner.getPassedMethodNames());
            } else {
                resultDetail.getIgnoredMethods().addAll(TestClassUtils.getIgnoredMethodNames(testClass));
                List<String> ranMethods = TestClassUtils.getNonIgnoredMethodNames(testClass);
                Set failedMethodNames = resultDetail.getFailedMethods().keySet();
                for (String methodName : ranMethods) {
                    if (failedMethodNames.contains(methodName)) continue;
                    resultDetail.getPassedMethods().add(methodName);
                }
            }
        }
        catch (InitializationError ie) {
            testResult = new Result();
            resultDetail = new TestResultDetailRepresentation(testClassName, testResult);
            RunListener listener = testResult.createListener();
            try {
                ie.getStackTrace();
                for (Throwable t : ie.getCauses()) {
                    t.getStackTrace();
                    Failure f = new Failure(Description.createSuiteDescription((String)testClassName, (Annotation[])new Annotation[0]), t);
                    listener.testFailure(f);
                    resultDetail.getFailedMethods().put("initialization", f);
                }
            }
            catch (Exception c) {
            }
        }
        catch (Throwable t) {
            testResult = new Result();
            resultDetail = new TestResultDetailRepresentation(testClassName, testResult);
            RunListener listener = testResult.createListener();
            try {
                t.getStackTrace();
                t.getCause().getStackTrace();
                Failure f = new Failure(Description.createSuiteDescription((String)testClassName, (Annotation[])new Annotation[0]), t.getCause());
                listener.testFailure(f);
                resultDetail.getFailedMethods().put("exception", f);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new BundleResultAndTestClass(bundleSymbolicName, resultDetail, testClass);
    }

    private Pair<Runner, Pair<String, Class>> getRunnerAndTest(String testClassName) throws InitializationError {
        Class<?> testClass;
        JUnitOSGiTestExecutor runner = null;
        Pair<String, Object> osgiTestPair = this.testLoader.findTestInstance(testClassName);
        String bundleSymbolicName = osgiTestPair.first();
        Object osgiTest = osgiTestPair.second();
        if (null != osgiTest) {
            testClass = osgiTest.getClass();
            runner = new JUnitOSGiTestExecutor(testClass, osgiTest);
        } else {
            Pair<String, Class<?>> testPair = BundleTestClassesManager.instance().findTestClass(testClassName);
            testClass = testPair != null ? testPair.second() : null;
            String string = bundleSymbolicName = testPair != null ? testPair.first() : null;
            if (null != testClass) {
                switch (TestClassUtils.getTestType(testClass)) {
                    case IT: {
                        if (TestCase.class.isAssignableFrom(testClass)) {
                            runner = new JUnit38ClassRunner(testClass);
                            break;
                        }
                        runner = new BlockJUnit4ClassRunner(testClass);
                        break;
                    }
                    case Unit: {
                        runner = TestCase.class.isAssignableFrom(testClass) ? new JUnit38ClassRunner(testClass) : new BlockJUnit4ClassRunner(testClass);
                    }
                }
            }
        }
        if (null == runner) {
            throw new InitializationError("unable to find runner for class: " + testClassName);
        }
        return Pair.pair(runner, Pair.pair(bundleSymbolicName, testClass));
    }

    private void loadTestDetails(Class<?> testClass, List<TestDetailRepresentation> testDetails) {
        try {
            TestDetailRepresentation detail = new TestDetailRepresentation(testClass.getName());
            detail.setAllTestMethods(TestClassUtils.getAllTestMethodNames(testClass));
            testDetails.add(detail);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
    }

    private class TestDetailComparator
    implements Comparator<TestDetailRepresentation> {
        private TestDetailComparator() {
        }

        @Override
        public int compare(TestDetailRepresentation o1, TestDetailRepresentation o2) {
            return o1.getClassname().compareTo(o2.getClassname());
        }
    }

    public class BundleResultAndTestClass {
        private final String bundleSymbolicName;
        private final TestResultDetailRepresentation result;
        private final Class<?> testClass;

        public BundleResultAndTestClass(String bundleSymbolicName, TestResultDetailRepresentation result, Class<?> testClass) {
            this.result = result;
            this.testClass = testClass;
            this.bundleSymbolicName = bundleSymbolicName;
        }

        public TestResultDetailRepresentation getResult() {
            return this.result;
        }

        public Class<?> getTestClass() {
            return this.testClass;
        }

        public String getBundleSymbolicName() {
            return this.bundleSymbolicName;
        }
    }
}

