package com.atlassian.plugins.osgi.javaconfig.conditions.product;

import com.atlassian.annotations.PublicApi;

/**
 * A Spring {@link org.springframework.context.annotation.Condition} that only returns <code>true</code> if the plugin
 * is running within Bamboo.
 *
 * See the notes on the {@link JiraOnly} condition for typical usage scenarios.
 *
 * @since 0.1
 */
@PublicApi
public final class BambooOnly extends AbstractProductCondition {

    /**
     * Constructor invoked reflectively by Spring.
     */
    public BambooOnly() {
        super("com.atlassian.bamboo.build.BuildExecutionManager");
    }
}
