package com.atlassian.plugins.osgi.javaconfig.annotations;

import org.springframework.context.annotation.Conditional;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * Create the components in the annotated configuration class or method if the list of classes given to the annotation all exist.
 *
 * @since 0.4
 */
@Retention(RetentionPolicy.RUNTIME)
@Target({ElementType.TYPE, ElementType.METHOD})
@Conditional(ConditionalOnClassCondition.class)
public @interface ConditionalOnClass {
    Class[] value();
}
