package com.atlassian.plugins.osgi.javaconfig.conditions.product;

import com.atlassian.annotations.PublicApi;

/**
 * A Spring {@link org.springframework.context.annotation.Condition} that only returns <code>true</code> if the plugin
 * is running within Refapp.
 *
 * @since 0.1
 */
@PublicApi
public final class RefappOnly extends AbstractProductCondition {

    /**
     * Constructor invoked reflectively by Spring.
     */
    public RefappOnly() {
        super("com.atlassian.refapp.api.ConnectionProvider");
    }
}
