package com.atlassian.plugins.osgi.javaconfig.conditions;

import com.atlassian.annotations.PublicApi;
import org.springframework.context.annotation.Condition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.type.AnnotatedTypeMetadata;

import java.util.Objects;

import static java.util.Objects.requireNonNull;

/**
 * Convenient base class for {@link Condition}s that evaluate a JVM system property.
 */
@PublicApi
public abstract class AbstractSystemPropertyCondition implements Condition {

    private final String propertyName;
    private final String trueValue;

    /**
     * Constructor.
     *
     * @param propertyName the name of the property to be evaluated (case-sensitive)
     * @param trueValue the value of that property that will cause this condition to be <code>true</code> (case-sensitive)
     */
    @SuppressWarnings("WeakerAccess")
    protected AbstractSystemPropertyCondition(final String propertyName, final String trueValue) {
        this.propertyName = requireNonNull(propertyName, "propertyName cannot be null");
        this.trueValue = requireNonNull(trueValue, "trueValue cannot be null");
    }

    @Override
    public final boolean matches(final ConditionContext context, final AnnotatedTypeMetadata metadata) {
        return Objects.equals(System.getProperty(propertyName), trueValue);
    }
}
