package com.atlassian.plugins.osgi.javaconfig.configs.beans;

import com.atlassian.annotations.PublicApi;
import com.atlassian.plugin.PluginAccessor;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import static com.atlassian.plugins.osgi.javaconfig.OsgiServices.importOsgiService;

/**
 * {@link org.springframework.context.annotation.Import}ing this configuration into your own {@link Configuration} class
 * will give you a Spring bean definition for the {@link PluginAccessor}.
 */
@Configuration
@PublicApi
public class PluginAccessorBean {

    @Bean
    public PluginAccessor pluginAccessor() {
        return importOsgiService(PluginAccessor.class);
    }
}
