package com.atlassian.plugins.osgi.javaconfig.configs.beans;

import com.atlassian.annotations.PublicApi;
import com.atlassian.plugin.module.ModuleFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import static com.atlassian.plugins.osgi.javaconfig.OsgiServices.importOsgiService;

/**
 * {@link org.springframework.context.annotation.Import}ing this configuration into your own plugin's
 * {@link Configuration} class will give you the {@link ModuleFactory} bean necessary for instantiating subclasses of
 * {@link com.atlassian.plugin.descriptors.AbstractModuleDescriptor}.
 */
@Configuration
@PublicApi
public class ModuleFactoryBean {

    @Bean
    public ModuleFactory moduleFactory() {
        return importOsgiService(ModuleFactory.class);
    }
}
