package com.atlassian.plugins.osgi.javaconfig.conditions.product;

import com.atlassian.annotations.PublicApi;

/**
 * A Spring {@link org.springframework.context.annotation.Condition} that only returns <code>true</code> if the plugin
 * is running within Jira.
 *
 * @since 0.1
 */
@PublicApi
public final class JiraOnly extends AbstractProductCondition {

    /**
     * Constructor invoked reflectively by Spring.
     */
    public JiraOnly() {
        super("com.atlassian.jira.bc.issue.IssueService");
    }
}
