package com.atlassian.plugins.osgi.javaconfig.conditions.product;

import com.atlassian.annotations.PublicApi;

/**
 * A Spring {@link org.springframework.context.annotation.Condition} that only returns <code>true</code> if the plugin
 * is running within Bitbucket. Does not support the pre-rebranding Stash, as it's no longer supported by Atlassian.
 *
 * @since 0.1
 */
@PublicApi
public final class BitbucketOnly extends AbstractProductCondition {

    /**
     * Constructor invoked reflectively by Spring.
     */
    public BitbucketOnly() {
        super("com.atlassian.bitbucket.repository.RepositoryService");
    }
}
