/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.main;

import com.atlassian.plugin.osgi.container.PackageScannerConfiguration;
import com.atlassian.plugin.osgi.container.impl.DefaultPackageScannerConfiguration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;

public class PackageScannerConfigurationBuilder {
    private String hostVersion;
    private final List<String> jarIncludes = new ArrayList<String>();
    private final List<String> jarExcludes = new ArrayList<String>();
    private final List<String> packageIncludes = new ArrayList<String>();
    private final List<String> packageExcludes = new ArrayList<String>();
    private final Map<String, String> packageVersions = new HashMap<String, String>();
    private ServletContext servletContext;

    public static PackageScannerConfigurationBuilder packageScannerConfiguration() {
        return new PackageScannerConfigurationBuilder();
    }

    public PackageScannerConfigurationBuilder() {
        this.copy((PackageScannerConfiguration)new DefaultPackageScannerConfiguration());
    }

    public PackageScannerConfigurationBuilder(PackageScannerConfiguration packageScannerConfiguration) {
        this.copy(packageScannerConfiguration);
    }

    private void copy(PackageScannerConfiguration config) {
        this.hostVersion = config.getCurrentHostVersion();
        this.packageIncludes.addAll(config.getPackageIncludes());
        this.packageExcludes.addAll(config.getPackageExcludes());
        this.jarIncludes.addAll(config.getJarIncludes());
        this.jarExcludes.addAll(config.getJarExcludes());
        this.packageVersions.putAll(config.getPackageVersions());
        this.servletContext = config.getServletContext();
    }

    public PackageScannerConfigurationBuilder hostVersion(String ... pkgs) {
        this.packageIncludes.addAll(Arrays.asList(pkgs));
        return this;
    }

    public PackageScannerConfigurationBuilder servletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
        return this;
    }

    public PackageScannerConfigurationBuilder packagesToInclude(String ... pkgs) {
        this.packageIncludes.addAll(Arrays.asList(pkgs));
        return this;
    }

    public PackageScannerConfigurationBuilder packagesToExclude(String ... pkgs) {
        this.packageExcludes.addAll(Arrays.asList(pkgs));
        return this;
    }

    public PackageScannerConfigurationBuilder packagesVersions(Map<String, String> packageToVersion) {
        this.packageVersions.putAll(packageToVersion);
        return this;
    }

    public PackageScannerConfigurationBuilder jarsToInclude(String ... jars) {
        this.jarIncludes.addAll(Arrays.asList(jars));
        return this;
    }

    public PackageScannerConfigurationBuilder jarsToExclude(String ... jars) {
        this.jarExcludes.addAll(Arrays.asList(jars));
        return this;
    }

    public PackageScannerConfiguration build() {
        return new ImmutablePackageScannerConfiguration(this);
    }

    private static final class ImmutablePackageScannerConfiguration
    implements PackageScannerConfiguration {
        private final String hostVersion;
        private final List<String> jarIncludes;
        private final List<String> jarExcludes;
        private final List<String> packageIncludes;
        private final List<String> packageExcludes;
        private final Map<String, String> packageVersions;
        private final ServletContext servletContext;

        ImmutablePackageScannerConfiguration(PackageScannerConfigurationBuilder builder) {
            this.hostVersion = builder.hostVersion;
            this.jarIncludes = Collections.unmodifiableList(new ArrayList(builder.jarIncludes));
            this.jarExcludes = Collections.unmodifiableList(new ArrayList(builder.jarExcludes));
            this.packageIncludes = Collections.unmodifiableList(new ArrayList(builder.packageIncludes));
            this.packageExcludes = Collections.unmodifiableList(new ArrayList(builder.packageExcludes));
            this.packageVersions = Collections.unmodifiableMap(new HashMap(builder.packageVersions));
            this.servletContext = builder.servletContext;
        }

        public List<String> getJarIncludes() {
            return this.jarIncludes;
        }

        public List<String> getJarExcludes() {
            return this.jarExcludes;
        }

        public List<String> getPackageIncludes() {
            return this.packageIncludes;
        }

        public List<String> getPackageExcludes() {
            return this.packageExcludes;
        }

        public Map<String, String> getPackageVersions() {
            return this.packageVersions;
        }

        public String getCurrentHostVersion() {
            return this.hostVersion;
        }

        public ServletContext getServletContext() {
            return this.servletContext;
        }
    }
}

