/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.main;

import com.atlassian.plugin.main.AtlassianPlugins;
import com.atlassian.plugin.main.PackageScannerConfigurationBuilder;
import com.atlassian.plugin.main.PluginsConfiguration;
import com.atlassian.plugin.main.PluginsConfigurationBuilder;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;

public class Main {
    public static void main(String[] args) {
        Main.initialiseLogger();
        File pluginDir = new File("plugins");
        pluginDir.mkdir();
        System.out.println("Created plugins directory " + pluginDir.getAbsolutePath());
        PluginsConfiguration config = PluginsConfigurationBuilder.pluginsConfiguration().pluginDirectory(pluginDir).packageScannerConfiguration(PackageScannerConfigurationBuilder.packageScannerConfiguration().packagesToInclude("org.apache.*", "com.atlassian.*", "org.dom4j*").packagesVersions(Collections.singletonMap("org.apache.log4j", "1.2.15")).build()).build();
        final AtlassianPlugins plugins = new AtlassianPlugins(config);
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                System.out.println("Cleaning up...");
                plugins.stop();
            }
        });
        plugins.start();
        Thread hotDeploy = new Thread("Hot Deploy"){

            public void run() {
                while (true) {
                    plugins.getPluginController().scanForNewPlugins();
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException e) {
                        return;
                    }
                }
            }
        };
        hotDeploy.start();
    }

    private static void initialiseLogger() {
        Properties logProperties = new Properties();
        InputStream in = null;
        try {
            in = Main.class.getResourceAsStream("/log4j-standalone.properties");
            logProperties.load(in);
            PropertyConfigurator.configure((Properties)logProperties);
            Logger.getLogger(Main.class).info((Object)"Logging initialized.");
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to load logging");
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
        }
    }
}

