package com.atlassian.plugin.event.events;

import com.atlassian.annotations.PublicApi;
import com.atlassian.plugin.ModuleDescriptor;

/**
 * Event fired when a plugin module is disabled, which can also happen when its
 * plugin is disabled or uninstalled.
 * 
 * @since 2.2.0
 * @see com.atlassian.plugin.event.events
 */
@PublicApi
public class PluginModuleDisabledEvent extends PluginModulePersistentEvent
{
    public PluginModuleDisabledEvent(final ModuleDescriptor<?> module, final boolean persistent)
    {
        super(module, persistent);
    }
}
