/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.devstatus;

import com.atlassian.annotations.PublicApi;
import com.atlassian.devstatus.EventEntity;
import com.atlassian.devstatus.EventInitiator;
import com.atlassian.event.api.AsynchronousPreferred;
import com.atlassian.event.remote.RemoteEvent;
import com.atlassian.event.remote.annotation.Capability;
import java.util.Collection;
import java.util.Collections;
import javax.annotation.Nonnull;

@AsynchronousPreferred
@Capability(value="JiraIssueEvent")
@PublicApi
public class JiraIssueEvent
extends RemoteEvent {
    private EventInitiator initiator = EventInitiator.EMPTY_INITIATOR;
    private Collection<String> issueKeys = Collections.emptyList();
    private EventEntity entity = EventEntity.EMPTY_ENTITY;

    protected JiraIssueEvent() {
    }

    public JiraIssueEvent(EventInitiator initiator, EventEntity entity, Collection<String> issueKeys) {
        this.initiator = initiator != null ? initiator : EventInitiator.EMPTY_INITIATOR;
        this.issueKeys = issueKeys != null ? Collections.unmodifiableCollection(issueKeys) : Collections.emptyList();
        this.entity = entity != null ? entity : EventEntity.EMPTY_ENTITY;
    }

    public EventEntity getEntity() {
        return this.entity;
    }

    public EventInitiator getInitiator() {
        return this.initiator;
    }

    @Nonnull
    public Collection<String> getIssueKeys() {
        return this.issueKeys;
    }
}

