package com.atlassian.plugin.connect.plugin.capabilities.descriptor.workflow;

import com.atlassian.jira.plugin.workflow.WorkflowFunctionModuleDescriptor;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.connect.modules.beans.WorkflowPostFunctionModuleBean;
import com.atlassian.plugin.connect.plugin.capabilities.descriptor.ConnectModuleDescriptorFactory;
import com.atlassian.plugin.connect.plugin.capabilities.util.ConnectContainerUtil;
import com.atlassian.plugin.connect.plugin.module.jira.workflow.RemoteWorkflowFunctionPluginFactory;
import com.atlassian.plugin.connect.plugin.module.jira.workflow.RemoteWorkflowPostFunctionProvider;
import com.atlassian.plugin.spring.scanner.annotation.component.JiraComponent;

import org.dom4j.Element;
import org.dom4j.dom.DOMElement;
import org.springframework.beans.factory.annotation.Autowired;

import static com.atlassian.jira.plugin.workflow.JiraWorkflowPluginConstants.*;
import static com.atlassian.plugin.connect.plugin.capabilities.descriptor.workflow.ConnectWorkflowFunctionModuleDescriptor.TRIGGERED_URL;
import static com.google.common.base.Preconditions.checkNotNull;

/**
 * A Factory that creates WorkflowFunctionModuleDescriptors from {@link WorkflowPostFunctionModuleBean}
 */
@JiraComponent
public class WorkflowPostFunctionModuleDescriptorFactory implements ConnectModuleDescriptorFactory<WorkflowPostFunctionModuleBean, WorkflowFunctionModuleDescriptor>
{
    private final ConnectContainerUtil connectContainerUtil;

    @Autowired
    public WorkflowPostFunctionModuleDescriptorFactory(ConnectContainerUtil connectContainerUtil)
    {
        this.connectContainerUtil = checkNotNull(connectContainerUtil);
    }

    @Override
    public WorkflowFunctionModuleDescriptor createModuleDescriptor(Plugin plugin, WorkflowPostFunctionModuleBean bean)
    {
        Element element = createDOMElement(bean);
        ConnectWorkflowFunctionModuleDescriptor moduleDescriptor = connectContainerUtil.createBean(ConnectWorkflowFunctionModuleDescriptor.class);
        moduleDescriptor.init(plugin, element);
        return moduleDescriptor;
    }

    private Element createDOMElement(WorkflowPostFunctionModuleBean bean)
    {
        Element element = new DOMElement("remote-workflow-post-function");

        element.addAttribute("class", RemoteWorkflowFunctionPluginFactory.class.getName());
        element.addElement("function-class").addText(RemoteWorkflowPostFunctionProvider.class.getName());

        element.addAttribute("key", bean.getKey());
        element.addAttribute("name", bean.getName().getValue());
        element.addAttribute("i18n-name-key", bean.getName().getI18n());
        element.addElement("description")
                .addText(bean.getDescription().getValue())
                .addAttribute("key", bean.getDescription().getI18n());

        element.addAttribute(TRIGGERED_URL, bean.getTriggered().getUrl());

        if (bean.hasView())
        {
            addResource(element, RESOURCE_NAME_VIEW, bean.getView().getUrl());
        }
        if (bean.hasEdit())
        {
            addResource(element, RESOURCE_NAME_EDIT_PARAMETERS, bean.getEdit().getUrl());
        }
        if (bean.hasCreate())
        {
            addResource(element, RESOURCE_NAME_INPUT_PARAMETERS, bean.getCreate().getUrl());
        }
        return element;
    }

    private void addResource(Element element, String resourceName, String url)
    {
        element.addElement("resource")
                .addAttribute("name", resourceName)
                .addAttribute("type", RESOURCE_TYPE_VELOCITY)
                .addAttribute("location", url);
    }
}
