/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.client.resource;

import com.atlassian.plugin.servlet.ServletContextFactory;
import com.atlassian.plugins.client.resource.PluginPathScanner;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StaticPluginPathScanner
implements PluginPathScanner {
    private static final Logger log = LoggerFactory.getLogger(StaticPluginPathScanner.class);
    private final ServletContextFactory servletContextFactory;

    public StaticPluginPathScanner(ServletContextFactory servletContextFactory) {
        this.servletContextFactory = servletContextFactory;
    }

    @Override
    public Iterable<String> getPaths(String directoryToScan) {
        ArrayList<String> paths = new ArrayList<String>();
        this.recursePath(directoryToScan, paths);
        return paths;
    }

    private void recursePath(String directory, Collection<String> paths) {
        Set resourcePaths = this.servletContextFactory.getServletContext().getResourcePaths(directory);
        if (resourcePaths == null) {
            log.warn("Cannot scan directory {} in web static as it does not exist", (Object)directory);
            return;
        }
        for (String resourcePath : resourcePaths) {
            if (resourcePath.endsWith("/")) {
                this.recursePath(resourcePath, paths);
                continue;
            }
            paths.add(resourcePath);
        }
    }
}

