/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.client.resource;

import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.osgi.factory.OsgiPlugin;
import com.atlassian.plugin.servlet.ServletContextFactory;
import com.atlassian.plugins.client.resource.OsgiBundledPathScanner;
import com.atlassian.plugins.client.resource.PluginPathScanner;
import com.atlassian.plugins.client.resource.StaticPluginPathScanner;

public class PluginPathScannerFactory {
    private final ServletContextFactory servletContextFactory;

    public PluginPathScannerFactory(ServletContextFactory servletContextFactory) {
        this.servletContextFactory = servletContextFactory;
    }

    public PluginPathScanner forPlugin(Plugin plugin, boolean webContextStatic) {
        if (webContextStatic) {
            return new StaticPluginPathScanner(this.servletContextFactory);
        }
        if (plugin instanceof OsgiPlugin) {
            return new OsgiBundledPathScanner((OsgiPlugin)plugin);
        }
        throw new UnsupportedOperationException("Plugin path scanning not supported for class type " + plugin.getClass().getCanonicalName());
    }
}

