package com.atlassian.depview.rest;

import com.atlassian.plugin.PluginAccessor;

import javax.xml.bind.annotation.XmlAttribute;
import java.util.Optional;

public class PluginBean {
    @XmlAttribute
    final String pluginKey;

    @XmlAttribute
    final String pluginClass;

    public PluginBean(final String pluginKey, final PluginAccessor pluginAccessor) {
        this.pluginKey = pluginKey;

        pluginClass = Optional.ofNullable(pluginAccessor.getPlugin(pluginKey))
                .map(p -> p.getClass().getSimpleName())
                .orElse("");
    }
}
