package com.atlassian.depview.rest;

import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.PluginAccessor;

import javax.inject.Inject;
import javax.inject.Singleton;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import java.util.Collection;
import java.util.function.Predicate;
import java.util.stream.Stream;

import static java.util.stream.Collectors.toList;

@Singleton
@Path("/modules")
public class ModulesResource {
    private final PluginAccessor pluginAccessor;

    @Inject
    public ModulesResource(final PluginAccessor pluginAccessor) {
        this.pluginAccessor = pluginAccessor;
    }

    @GET
    @Produces({MediaType.APPLICATION_JSON})
    public Response getBundles(@QueryParam("q") String query) {
        final Collection<ModuleDescriptor<Object>> modules = pluginAccessor.getModuleDescriptors(
                (Predicate<ModuleDescriptor<Object>>) objectModuleDescriptor -> true);

        final Stream<ModuleBean> moduleBeanStream = modules.stream().map(m -> new ModuleBean(
                m.getPluginKey(),
                m.getPlugin().getName(),
                m.getKey(),
                m.getName(),
                m.getModuleClass(),
                pluginAccessor.isPluginModuleEnabled(m.getCompleteKey())));

        return Response.ok(moduleBeanStream.collect(toList())).build();
    }

}
