AJS.namespace("Atlassian.Notifications.NotificationSchemeView");

Atlassian.Notifications.NotificationSchemeView = Backbone.View.extend({

    template: Atlassian.Templates.Notifications.schemeHeader,

    events: {
        "click #add_notification": "addNotification"
    },

    initialize: function () {
        _.bindAll(this);

        this.model.on("change", this.render);
    },

    addNotification: function (e) {
        e.preventDefault();
        this.addView.showThrobber();
        this.addModel.clearSelection();
        if (this.addModel.get("loaded")) {
            this.addView.render();
        } else {
            //if the options haven't loaded yet, wait until they have and then show the dialog!
            var that = this;
            this.addModel.on("optionsFetched", function () {
                that.addView.render();
            });
        }
    },

    reload: function () {
        this.model.fetch();
    },

    render: function () {
        this.$el.empty();
        this.$el.append(this.template(this.model.toJSON()));

        var notifications = this.model.get("notifications");
        notifications.on("saveSuccess", this.reload);

        var notificationsView = new Atlassian.Notifications.NotificationsView({model: notifications});
        this.$el.append(notificationsView.render());

        if (this.addView === undefined) {
            var newNotificationModel = new Atlassian.Notifications.NotificationModel(
                {"schemeId": this.model.get("id")});
            this.addModel = new Atlassian.Notifications.AddNotificationModel({
                schemeId: this.model.get("id"),
                notification: newNotificationModel
            });
            this.addModel.on("saveSuccess", this.reload);

            this.addView = new Atlassian.Notifications.AddNotificationView({model: this.addModel});

            this.addModel.fetchOptions();
        }

        return this.$el;
    }
});