AJS.namespace("Atlassian.Notifications.NotificationModel");
AJS.namespace("Atlassian.Notifications.NotificationsCollection");

Atlassian.Notifications.NotificationModel = Backbone.Model.extend({

    properties:["id", "jql", "schemeId", "recipients", "events"],
    urlRoot: function() {
        return AJS.contextPath() + "/rest/notifications/1.0/scheme/" + this.get("schemeId") + "/notification";
    },

    initialize: function(attributes) {
        _.bindAll(this);
        if(attributes && !attributes.recipients) {
            this.set("recipients", new Atlassian.Notifications.RecipientCollection());
        }
        if(attributes && !attributes.events) {
            this.set("events", new Atlassian.Notifications.EventCollection());
        }
    },

    addRecipient: function(recipientModel) {
        var exists = this.get("recipients").any(function(existingRecipient) {
            return existingRecipient.getKey() == recipientModel.getKey();
        });
        if(!exists) {
            var recipientJSON = recipientModel.toJSON();
            delete recipientJSON.id;
            delete recipientJSON.parameterConfig;
            this.get("recipients").add(new Atlassian.Notifications.RecipientModel(recipientJSON));
        }
    },

    removeRecipientByKey: function(recipientKey) {
        var existingRecipient = this.get("recipients").find(function(existingRecipient) {
            return existingRecipient.getKey() == recipientKey;
        });
        if(existingRecipient) {
            this.get("recipients").remove(existingRecipient);
        }
    },

    addEvents:function(events) {
        var that = this;
        that.get("events").reset();
        _.each(events, function(eventKey) {
            that.get("events").add(new Atlassian.Notifications.NotificationEventModel({"eventKey": eventKey}));
        });
    },

    removeEventById: function(eventKey) {
        var existingEvent = this.get("events").find(function(existingEvent) {
            return existingEvent.get("eventKey") == eventKey;
        });
        if(existingEvent) {
            this.get("events").remove(existingEvent);
        }
    },

    parse:function(resp) {
        return {
            "id":resp.id,
            "schemeId": resp.schemeId,
            "filterSummary": resp.filterSummary,
            "recipients":new Atlassian.Notifications.RecipientCollection(resp.recipients, {parse:true}),
            "events":new Atlassian.Notifications.EventCollection(resp.events, {parse:true})
        }
    }
});

Atlassian.Notifications.NotificationsCollection = Backbone.Collection.extend({
    model:Atlassian.Notifications.NotificationModel
});