AJS.namespace("Atlassian.Notifications.AddNotificationModel");

Atlassian.Notifications.AddNotificationModel = Backbone.Model.extend({

    properties:["schemeId", "notification", "events", "recipients", "filterHtml"],

    initialize: function() {
        _.bindAll(this);
    },

    fetchOptions:function() {
        this.set({"loaded": false}, {silent:true});
        var that = this;
        var urlSuffix = this.get("notification").get("id") === undefined ? "" : "/" + this.get("notification").get("id");
        AJS.$.ajax({
            url:AJS.contextPath() + "/rest/notifications/1.0/addoptions" + urlSuffix,
            type:"GET",
            contentType:"application/json",
            success:function (resp) {
                that.set({
                    "events":resp.events,
                    "recipients":resp.recipients,
                    "servers":resp.servers,
                    "filterHtml":resp.filterHtml,
                    "loaded": true
                });
                that.trigger("optionsFetched");
            }
        })
    },

    getRecipient:function(recipientId) {
        var recipient = _.find(this.get("recipients"), function(item) {
            return item.type === recipientId;
        });
        if(!recipient) {
            return _.find(this.get("servers"), function(item) {
                return item.serverId == recipientId;
            })
        }
        return recipient;
    },

    removeRecipient:function(recipientKey) {
        this.get("notification").removeRecipientByKey(recipientKey);
        this.trigger("change:selectedRecipients");
    },

    addRecipient: function(recipient) {
        this.get("notification").addRecipient(recipient);
        this.trigger("change:selectedRecipients");
    },

    addEvents:function(events) {
        this.get("notification").addEvents(events);
    },

    getConfiguredRecipients:function() {
        return this.get("notification").get("recipients").map(function(recipientModel) {
            recipientJson = recipientModel.toJSON();
            recipientJson["key"] = recipientModel.getKey();
            return recipientJson;
        });
    },

    getSelectedEventIds: function() {
        var ret = {};
        this.get("notification").get("events").each(function(eventModel) {
            ret[eventModel.get("eventKey")] = true;
        });
        return ret;
    },

    clearSelection:function() {
        this.unset("notification");
        this.set({"notification": new Atlassian.Notifications.NotificationModel({"schemeId": this.get("schemeId")})});
    },

    saveOnServer:function(options) {
        var that = this;
        this.get("notification").save(undefined,{
            success:function(model, resp) {
                model.trigger("saveSuccess");
                that.trigger("saveSuccess");
            },
            error:function(model, resp) {
                var errors = undefined;
                try
                {
                    if(resp && resp.responseText) {
                        errors = JSON.parse(resp.responseText);
                    } else {
                        errors = {"errorMessages":[AJS.I18n.getText("notifications.plugin.unknown.error")]}
                    }
                }
                catch(error) {
                    errors = {"errorMessages":[AJS.I18n.getText("notifications.plugin.unknown.error")]}
                }
                that.trigger("saveError", errors);
            }
        });
    }

});