(function () {
    AJS.$(function () {
        var queueInterval = 0;

        AJS.$(".notifications-content-body").html(Notification.Templates.tabContainer());
        var $tabContainer = AJS.$(".notifications-content-body").find(".notifications-tabs");
        AJS.tabs.setup();
        var that = this;
        that.dialog = new AJS.Dialog({
            width:810,
            height:500,
            id:"error-details-dialog"
        });
        that.dialog.addHeader(AJS.I18n.getText('notifications.plugin.error.details'));
        that.dialog.addLink(AJS.I18n.getText("notifications.plugin.common.words.close"), function() {that.dialog.hide();});
        that.dialog.addPanel("error-details-page");

        var updateQueue = function() {
            AJS.$(AJS.$.ajax({
                url:AJS.contextPath() + "/rest/notifications/1.0/queue",
                success:function (resp) {
                    var mainQueue = _.filter(resp.queue, function(item) {
                        var state = item.state.id;
                        return state !== "ERROR" && state !== "AWAITING_RESEND" && item.retryAttempts <= 1;
                    });
                    var resendQueue = _.filter(resp.queue, function(item) {
                        var state = item.state.id;
                        return state === "AWAITING_RESEND" || item.retryAttempts > 1;
                    });


                    $tabContainer.find("#tabs-main-queue").html(Notification.Templates.queueTable({
                        queue:mainQueue, isErrorQueue:false, isResendQueue:false }));
                    $tabContainer.find("#tabs-resend-queue").html(Notification.Templates.queueTable({
                        queue:resendQueue, isErrorQueue:false, isResendQueue:true }));

                    var leftServers = [];
                    var rightServers = [];
                    for(var i = 0; i<resp.serverStatus.length; i++) {
                        if(i % 2 == 0) {
                            leftServers.push(resp.serverStatus[i]);
                        } else {
                            rightServers.push(resp.serverStatus[i]);
                        }
                    }

                    $tabContainer.find("#tabs-server-queue").html(Notification.Templates.servers({
                        left:leftServers,
                        right:rightServers
                    }));

                    $tabContainer.find("#tabs-main-queue-title").text(AJS.I18n.getText('notifications.plugin.queue.title', mainQueue.length));
                    $tabContainer.find("#tabs-resend-queue-title").text(AJS.I18n.getText('notifications.plugin.queue.resend', resendQueue.length));
                },
                error:function(resp) {
                    alert(AJS.I18n.getText("notifications.plugin.unknown.error"));
                    clearInterval(queueInterval);
                }
            })).throbber({target:".throbber"});
        };

        $tabContainer.delegate(".error-summary", "click", function(e) {
            e.preventDefault();
            var panel = that.dialog.getPanel(0, 0);
            var error = AJS.$(this).parent();
            panel.html(error.html());
            that.dialog.show();
        });

        $tabContainer.delegate(".clear-errors", "click", function(e) {
            e.preventDefault();
            AJS.$(AJS.$.ajax({
                url:AJS.$(this).attr("href"),
                type:"DELETE",
                success:function() {
                    updateQueue();
                },
                error:function() {
                    alert(AJS.I18n.getText("notifications.plugin.unknown.error"));
                }
            })).throbber({target:".throbber"});
        });

        queueInterval = setInterval(updateQueue, 10000);
        updateQueue();
    });
})();