(function () {
    AJS.namespace("Notifications.FormDialog");

    Notifications.FormDialog = Class.extend({
        init:function (options) {
            var instance = this;
            this.options = options;
            this.$trigger = AJS.$(this.options.trigger);
            this.url = this.$trigger.attr("href");
            this.options.id = this.options.id || "notifiations-form-dialog";

            AJS.$(".notifications-form-dialog").remove();
            this.dialog = new AJS.Dialog({
                width:this.options.width || 810,
                height:this.options.height || 600,
                id:this.options.id
            });
            AJS.$(this.dialog.popup.element).addClass("notifications-form-dialog");

            this.ajaxOptions = AJS.$.extend({
                url:this.url,
                success:function (resp) {
                    instance._renderContents(resp);
                    instance.dialog.show();
                },
                error:function (resp) {
                    alert(AJS.I18n.getText("notifications.plugin.unknown.error"));
                },
                complete:function (xhr, status) {
                    instance._hideLoadingIndicator();
                }
            }, this.options.ajaxOptions);
        },

        show:function () {
            this._showLoadingIndicator();
            AJS.$.ajax(this.ajaxOptions);
        },

        hide:function () {
            this.dialog.hide();
        },

        _getThrobber:function() {
            if(!this.$throbber) {
                this.$throbber = AJS.$("<span class=\"icon throbber loading notif-hidden\"></span>");
                this.dialog.popup.element.find(".dialog-button-panel").prepend(this.$throbber);
            }
            return this.$throbber;
        },

        _showThrobber:function() {
            this._getThrobber().show();
        },

        _hideThrobber:function() {
            this._getThrobber().hide();
        },

        _handleSubmit: function($form) {
            var instance = this;
            //show throbber
            instance._showThrobber();

            $form.addClass("submitting");
            AJS.$(".error", $form).remove();
            var formData = $form.serializeArray();

            AJS.$.ajax({
                url: $form.attr("action"),
                type: !!this.options.edit ? "PUT" : "POST",
                contentType:"application/json",
                data:JSON.stringify({
                    config:formData
                }),
                success:function (resp) {
                    $form.removeClass("submitting");
                    window.location.reload();

                },
                error:function (resp) {
                    if(resp && resp.responseText) {
                        try
                        {
                            var errorCollection = JSON.parse(resp.responseText);
                            if(errorCollection && errorCollection.errors) {
                                AJS.$.each(errorCollection.errors, function(key, value) {
                                    AJS.$("input[name='" + key + "']", $form).after("<div class='error'>" + value + "</div>");
                                });
                            }
                            if(errorCollection && errorCollection.errorMessages) {
                                var errors = "";
                                AJS.$.each(errorCollection.errorMessages, function(index, message) {
                                    errors += message + "<br/>";
                                });
                                if(errors !== "") {
                                    AJS.$("#errorContainer", $form).append("<div class='field-group error'>" + errors + "</div>");
                                }
                            }
                        }
                        catch(error) {
                            alert(AJS.I18n.getText("notifications.plugin.unknown.error"));
                        }
                    }
                    $form.removeClass("submitting");
                },
                complete:function(xhr, status) {
                    instance._hideThrobber();
                }
            });
        },

        _renderContents:function (contents) {
            var $contents = AJS.$(contents), instance = this, $formHeading = AJS.$(":header:first", $contents);
            this.dialog.addHeader($formHeading.text());
            $formHeading.remove();

            this.dialog.addPanel(this.options.id);
            var panel = this.dialog.getPanel(0, 0);

            panel.html($contents);

            $contents.find("form").submit(function(e) {
                e.preventDefault();
                var $form = AJS.$(this);
                instance._handleSubmit.call(instance, $form);
            });

            var $buttonContainer = AJS.$("div.buttons-container", $contents);
            var $button = $buttonContainer.find(".button:first");
            this.dialog.addButton($button.val(), function () { $contents.find("form").submit(); }, "aui-button " + $button.attr("id"));
            this.dialog.addLink(AJS.I18n.getText("notifications.plugin.common.forms.cancel"), function () {
                instance.hide();
            }, "cancel-dialog");

            $buttonContainer.remove();

            if (this.options.decorateContents) {
                this.options.decorateContents($contents);
            }

            this.dialog.popup.element.addClass("jira-dialog-content-ready");
        },

        _showLoadingIndicator:function () {

            var instance = this, heightOfSprite = 440, currentOffsetOfSprite = 0;

            clearInterval(this.loadingTimer);

            this._getLoadingIndicator().show();
            this.loadingTimer = window.setInterval(function () {
                if (currentOffsetOfSprite === heightOfSprite) {
                    currentOffsetOfSprite = 0;
                }
                currentOffsetOfSprite = currentOffsetOfSprite + 40;
                instance._getLoadingIndicator().css("backgroundPosition", "0 -" + currentOffsetOfSprite + "px");
            }, 50);
        },

        _hideLoadingIndicator:function () {
            clearInterval(this.loadingTimer);
            this._getLoadingIndicator().hide();
        },

        _getLoadingIndicator:function () {
            if (!this.loadingIndicator) {
                this.loadingIndicator = AJS.$("<div class=\"aui-loading\"></div>");
                this.loadingIndicator.appendTo("body");
            }
            return this.loadingIndicator;
        }
    });
})();