/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.spring.scanner.runtime.impl;

import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsDevService;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.export.ModuleType;
import com.atlassian.plugin.spring.scanner.runtime.impl.ExportedSeviceManager;
import com.atlassian.plugin.spring.scanner.runtime.impl.util.AnnotationIndexReader;
import com.google.common.collect.ImmutableMap;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import java.util.stream.Stream;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.DestructionAwareBeanPostProcessor;

public class ServiceExporterBeanPostProcessor
implements DestructionAwareBeanPostProcessor,
InitializingBean {
    public static final String OSGI_SERVICE_SUFFIX = "_osgiService";
    static final String ATLASSIAN_DEV_MODE_PROP = "atlassian.dev.mode";
    private static final Logger log = LoggerFactory.getLogger(ServiceExporterBeanPostProcessor.class);
    private final boolean isDevMode = Boolean.parseBoolean(System.getProperty("atlassian.dev.mode", "false"));
    private final BundleContext bundleContext;
    private final ConfigurableListableBeanFactory beanFactory;
    private final ExportedSeviceManager serviceManager;
    private String profileName;
    private ImmutableMap<String, String[]> exports;

    public ServiceExporterBeanPostProcessor(BundleContext bundleContext, ConfigurableListableBeanFactory beanFactory) {
        this(bundleContext, beanFactory, new ExportedSeviceManager());
    }

    ServiceExporterBeanPostProcessor(BundleContext bundleContext, ConfigurableListableBeanFactory beanFactory, ExportedSeviceManager serviceManager) {
        this.bundleContext = bundleContext;
        this.beanFactory = beanFactory;
        this.profileName = null;
        this.serviceManager = serviceManager;
    }

    public void setProfileName(String profileName) {
        this.profileName = profileName;
    }

    public void afterPropertiesSet() {
        ImmutableMap.Builder exportBuilder = ImmutableMap.builder();
        String[] profileNames = AnnotationIndexReader.splitProfiles(this.profileName);
        this.parseExportsForExportFile((ImmutableMap.Builder<String, String[]>)exportBuilder, "exports", profileNames);
        if (this.isDevMode) {
            this.parseExportsForExportFile((ImmutableMap.Builder<String, String[]>)exportBuilder, "dev-exports", profileNames);
        }
        this.exports = exportBuilder.build();
    }

    private void parseExportsForExportFile(ImmutableMap.Builder<String, String[]> exportBuilder, String exportFileName, String[] profileNames) {
        String[] defaultInterfaces = new String[]{};
        for (String fileToRead : AnnotationIndexReader.getIndexFilesForProfiles(profileNames, exportFileName)) {
            List<String> exportData = AnnotationIndexReader.readAllIndexFilesForProduct(fileToRead, this.bundleContext);
            for (String export : exportData) {
                String[] targetAndInterfaces = export.split("#");
                String target = targetAndInterfaces[0];
                String[] interfaces = targetAndInterfaces.length > 1 ? targetAndInterfaces[1].split(",") : defaultInterfaces;
                exportBuilder.put((Object)target, (Object)interfaces);
            }
        }
    }

    public void postProcessBeforeDestruction(Object bean, String beanName) {
        if (this.serviceManager.hasService(bean)) {
            Object serviceBean;
            this.serviceManager.unregisterService(this.bundleContext, bean);
            String serviceName = this.getServiceName(beanName);
            if (this.beanFactory.containsBean(serviceName) && null != (serviceBean = this.beanFactory.getBean(serviceName))) {
                this.beanFactory.destroyBean(serviceName, serviceBean);
            }
        }
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) {
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) {
        Class[] interfaces = new Class[]{};
        Class beanTargetClass = AopUtils.getTargetClass((Object)bean);
        String beanClassName = beanTargetClass.getName();
        if (this.exports.containsKey((Object)beanClassName) || this.isPublicComponent(beanTargetClass)) {
            if (this.exports.containsKey((Object)beanClassName)) {
                interfaces = this.getExportedInterfaces(bean, beanName, beanClassName);
            } else if (this.hasAnnotation(beanTargetClass, ModuleType.class)) {
                interfaces = beanTargetClass.getAnnotation(ModuleType.class).value();
            } else if (this.hasAnnotation(beanTargetClass, ExportAsService.class)) {
                interfaces = beanTargetClass.getAnnotation(ExportAsService.class).value();
            } else if (this.hasAnnotation(beanTargetClass, ExportAsDevService.class)) {
                interfaces = beanTargetClass.getAnnotation(ExportAsDevService.class).value();
            }
            if (interfaces.length < 1 && (interfaces = beanTargetClass.getInterfaces()).length < 1) {
                interfaces = new Class[]{beanTargetClass};
            }
            try {
                ServiceRegistration serviceRegistration = this.serviceManager.registerService(this.bundleContext, bean, beanName, new Hashtable<String, Object>(), interfaces);
                String serviceName = this.getServiceName(beanName);
                this.beanFactory.initializeBean((Object)serviceRegistration, serviceName);
            }
            catch (Exception e) {
                log.error("Unable to register bean '{}' as an OSGi exported service", (Object)beanName, (Object)e);
            }
        }
        return bean;
    }

    private Class<?>[] getExportedInterfaces(Object bean, String beanName, String beanClassName) {
        ClassLoader beanClassLoader = bean.getClass().getClassLoader();
        return (Class[])Arrays.stream((Object[])this.exports.get((Object)beanClassName)).flatMap(interfaceName -> ServiceExporterBeanPostProcessor.loadInterfaceClass(interfaceName, beanClassLoader, beanName)).toArray(Class[]::new);
    }

    private static Stream<Class<?>> loadInterfaceClass(String interfaceName, ClassLoader classLoader, String beanName) {
        try {
            return Stream.of(classLoader.loadClass(interfaceName));
        }
        catch (ClassNotFoundException cnfe) {
            log.warn("Cannot find class for export '{}' of bean '{}': {}", new Object[]{interfaceName, beanName, cnfe});
            return Stream.empty();
        }
    }

    private boolean isPublicComponent(Class<?> beanTargetClass) {
        return this.hasAnnotation(beanTargetClass, ModuleType.class) || this.hasAnnotation(beanTargetClass, ExportAsService.class) || this.hasAnnotation(beanTargetClass, ExportAsDevService.class) && this.isDevMode;
    }

    private boolean hasAnnotation(Class<?> beanTargetClass, Class<? extends Annotation> annotationClass) {
        return beanTargetClass.isAnnotationPresent(annotationClass);
    }

    private String getServiceName(String beanName) {
        return beanName + OSGI_SERVICE_SUFFIX;
    }
}

