/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.spring.scanner.runtime.impl;

import com.google.common.base.Equivalence;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.eclipse.gemini.blueprint.service.exporter.OsgiServiceRegistrationListener;
import org.eclipse.gemini.blueprint.service.exporter.support.DefaultInterfaceDetector;
import org.eclipse.gemini.blueprint.service.exporter.support.ExportContextClassLoaderEnum;
import org.eclipse.gemini.blueprint.service.exporter.support.InterfaceDetector;
import org.eclipse.gemini.blueprint.service.exporter.support.OsgiServiceFactoryBean;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExportedSeviceManager {
    private static final Logger log = LoggerFactory.getLogger(ExportedSeviceManager.class);
    private final ConcurrentMap<Equivalence.Wrapper<Object>, OsgiServiceFactoryBean> exporters = new ConcurrentHashMap<Equivalence.Wrapper<Object>, OsgiServiceFactoryBean>();

    public ServiceRegistration registerService(BundleContext bundleContext, Object bean, String beanName, Map<String, Object> serviceProps, Class<?> ... interfaces) throws Exception {
        OsgiServiceFactoryBean osgiExporter = this.createExporter(bundleContext, bean, beanName, serviceProps, interfaces);
        OsgiServiceFactoryBean replacedBean = this.exporters.put(this.getKey(bean), osgiExporter);
        if (replacedBean != null) {
            log.warn("Tried to register the same intance of {} twice", replacedBean.getClass());
        }
        return osgiExporter.getObject();
    }

    public boolean hasService(Object bean) {
        return this.exporters.containsKey(this.getKey(bean));
    }

    public void unregisterService(BundleContext bundleContext, Object bean) {
        OsgiServiceFactoryBean exporter = (OsgiServiceFactoryBean)this.exporters.remove(this.getKey(bean));
        if (null != exporter) {
            exporter.destroy();
        }
    }

    private OsgiServiceFactoryBean createExporter(BundleContext bundleContext, Object bean, String beanName, Map<String, Object> serviceProps, Class<?>[] interfaces) throws Exception {
        serviceProps.put("org.eclipse.gemini.blueprint.bean.name", beanName);
        OsgiServiceFactoryBean exporter = new OsgiServiceFactoryBean();
        exporter.setInterfaceDetector((InterfaceDetector)DefaultInterfaceDetector.DISABLED);
        exporter.setBeanClassLoader(bean.getClass().getClassLoader());
        exporter.setBeanName(beanName);
        exporter.setBundleContext(bundleContext);
        exporter.setExportContextClassLoader(ExportContextClassLoaderEnum.UNMANAGED);
        exporter.setInterfaces((Class[])interfaces);
        exporter.setServiceProperties(serviceProps);
        exporter.setTarget(bean);
        exporter.setListeners(new OsgiServiceRegistrationListener[0]);
        exporter.afterPropertiesSet();
        return exporter;
    }

    private Equivalence.Wrapper<Object> getKey(Object bean) {
        return Equivalence.identity().wrap(bean);
    }
}

