/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.spring.scanner.util;

import com.atlassian.plugin.spring.scanner.ProductFilter;
import com.google.common.annotations.VisibleForTesting;

public class ProductFilterUtil {
    private static ProductFilterUtil INSTANCE;
    @VisibleForTesting
    static final String CLASS_ON_JIRA_CLASSPATH = "com.atlassian.jira.plugin.issuetabpanel.IssueTabPanelModuleDescriptor";
    @VisibleForTesting
    static final String CLASS_ON_CONFLUENCE_CLASSPATH = "com.atlassian.confluence.plugin.descriptor.MacroModuleDescriptor";
    private ProductFilter filterForProduct;

    private ProductFilterUtil() {
        try {
            Class.forName(CLASS_ON_JIRA_CLASSPATH);
            this.filterForProduct = ProductFilter.JIRA;
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
        try {
            Class.forName(CLASS_ON_CONFLUENCE_CLASSPATH);
            this.filterForProduct = ProductFilter.CONFLUENCE;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    public static ProductFilter getFilterForCurrentProduct() {
        return ProductFilterUtil.getInstance().getFilterForProduct();
    }

    public static String getLowerCurrentProductName() {
        ProductFilter filter = ProductFilterUtil.getFilterForCurrentProduct();
        if (null == filter) {
            return "";
        }
        return filter.name().toLowerCase();
    }

    public ProductFilter getFilterForProduct() {
        return this.filterForProduct;
    }

    private static ProductFilterUtil getInstance() {
        if (null == INSTANCE) {
            INSTANCE = new ProductFilterUtil();
        }
        return INSTANCE;
    }
}

