/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.spring.scanner.extension;

import com.atlassian.plugin.osgi.factory.OsgiPlugin;
import com.atlassian.plugin.spring.scanner.util.AnnotationIndexReader;
import com.atlassian.plugin.spring.scanner.util.SpringDMUtil;
import java.net.URL;
import java.util.Properties;
import java.util.TreeSet;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;

public class ComponentImportBeanFactoryPostProcessor
implements BeanFactoryPostProcessor {
    private final BundleContext bundleContext;
    private boolean autoImports;
    private String profileName;
    private final Log log = LogFactory.getLog(this.getClass());

    public ComponentImportBeanFactoryPostProcessor(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
        this.autoImports = false;
        this.profileName = null;
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        BeanDefinitionRegistry registry = (BeanDefinitionRegistry)beanFactory;
        Bundle bundle = this.bundleContext.getBundle();
        TreeSet<String> classNames = new TreeSet<String>();
        String[] profileNames = new String[]{};
        if (StringUtils.isNotBlank((String)this.profileName)) {
            profileNames = StringUtils.split((String)this.profileName, (char)',');
        }
        if (profileNames.length > 0) {
            for (String profileName : profileNames) {
                if (!StringUtils.isNotBlank((String)(profileName = StringUtils.defaultIfBlank((String)profileName, (String)"").trim()))) continue;
                String fileToRead = "META-INF/plugin-components/profile-" + profileName + "/" + "imports";
                classNames.addAll(AnnotationIndexReader.readAllIndexFilesForProduct(fileToRead, bundle));
            }
        } else {
            String fileToRead = "META-INF/plugin-components/imports";
            classNames.addAll(AnnotationIndexReader.readAllIndexFilesForProduct(fileToRead, bundle));
        }
        for (String className : classNames) {
            String[] typeAndName = StringUtils.split((String)className, (String)"#");
            String beanType = typeAndName[0];
            String beanName = typeAndName.length > 1 ? typeAndName[1] : "";
            try {
                Class<?> beanClass = beanFactory.getBeanClassLoader().loadClass(beanType);
                this.registerComponentImportBean(registry, beanClass, beanName);
            }
            catch (ClassNotFoundException e) {
                this.log.error((Object)("Unable to load class '" + beanType + "' for component importation purposes.  Skipping..."));
            }
        }
        this.processMetaData(registry, profileNames);
    }

    private void processMetaData(BeanDefinitionRegistry registry, String[] profileNames) {
        if (profileNames.length > 0) {
            for (String profileName : profileNames) {
                if (!StringUtils.isNotBlank((String)(profileName = StringUtils.defaultIfBlank((String)profileName, (String)"").trim()))) continue;
                String fileToRead = "META-INF/plugin-components/profile-" + profileName + "/" + "metadata.properties";
                URL url = this.bundleContext.getBundle().getResource(fileToRead);
                this.processMetaDataProperties(registry, AnnotationIndexReader.readPropertiesFile(url));
            }
        } else {
            String fileToRead = "META-INF/plugin-components/metadata.properties";
            URL url = this.bundleContext.getBundle().getResource(fileToRead);
            this.processMetaDataProperties(registry, AnnotationIndexReader.readPropertiesFile(url));
        }
    }

    private void processMetaDataProperties(BeanDefinitionRegistry registry, Properties properties) {
    }

    private void registerComponentImportBean(BeanDefinitionRegistry registry, Class beanClass, String beanName) {
        String serviceBeanName = beanName;
        if ("".equals(serviceBeanName)) {
            serviceBeanName = StringUtils.uncapitalize((String)beanClass.getSimpleName());
        }
        this.registerBeanDefinition(registry, serviceBeanName, "(objectClass=" + beanClass.getName() + ")", beanClass);
    }

    private void registerBeanDefinition(BeanDefinitionRegistry registry, String beanName, String filter, Class interfaces) {
        Class osgiServiceProxyFactoryBeanClass = SpringDMUtil.getInstance().getOsgiServiceFactoryBeanFactory().getProxyClass();
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition((Class)osgiServiceProxyFactoryBeanClass);
        builder.setAutowireMode(3);
        builder.setRole(2);
        if (StringUtils.isNotBlank((String)filter)) {
            builder.addPropertyValue("filter", (Object)filter);
        }
        builder.addPropertyValue("interfaces", (Object)new Class[]{interfaces});
        builder.addPropertyValue("beanClassLoader", (Object)OsgiPlugin.class.getClassLoader());
        AbstractBeanDefinition newDefinition = builder.getBeanDefinition();
        registry.registerBeanDefinition(beanName, (BeanDefinition)newDefinition);
    }

    public void setAutoImports(boolean autoImports) {
        this.autoImports = autoImports;
    }

    public void setProfileName(String profileName) {
        this.profileName = profileName;
    }
}

