/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.spring.scanner.maven;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Exclusion;
import org.apache.maven.shared.dependency.graph.DependencyNode;
import org.apache.maven.shared.dependency.graph.filter.DependencyNodeFilter;
import org.apache.maven.shared.dependency.graph.traversal.CollectingDependencyNodeVisitor;
import org.apache.maven.shared.dependency.graph.traversal.DependencyNodeVisitor;
import org.apache.maven.shared.dependency.graph.traversal.FilteringDependencyNodeVisitor;

final class ScannedDependencyArtifactBuilder {
    static List<Artifact> buildScannedArtifacts(DependencyNode projectDependencyGraph, final List<Dependency> configuredScannedDependencies) {
        final ArrayList<Artifact> artifacts = new ArrayList<Artifact>();
        projectDependencyGraph.accept(new DependencyNodeVisitor(){

            public boolean visit(DependencyNode node) {
                return true;
            }

            public boolean endVisit(DependencyNode node) {
                Artifact artifact = node.getArtifact();
                ScannedDependencyArtifactBuilder.artifactInConfiguredList(artifact, configuredScannedDependencies).ifPresent(dependency -> artifacts.addAll(ScannedDependencyArtifactBuilder.findIncludedTransitiveDeps(node, dependency)));
                return true;
            }
        });
        return artifacts;
    }

    private static Optional<Dependency> artifactInConfiguredList(Artifact artifact, List<Dependency> configuredScannedDependencies) {
        return configuredScannedDependencies.stream().filter(dependency -> ScannedDependencyArtifactBuilder.matchesIncludingWildcards(artifact, dependency)).findFirst();
    }

    private static boolean matchesIncludingWildcards(Artifact artifact, Dependency dependency) {
        if ("*".equals(dependency.getArtifactId())) {
            return dependency.getGroupId().equals(artifact.getGroupId());
        }
        return dependency.getGroupId().equals(artifact.getGroupId()) && dependency.getArtifactId().equals(artifact.getArtifactId());
    }

    private static List<Artifact> findIncludedTransitiveDeps(DependencyNode dependencyNode, Dependency dependency) {
        DependencyNodeFilter includedDeps = node -> !ScannedDependencyArtifactBuilder.isExcluded(node.getArtifact(), dependency.getExclusions());
        CollectingDependencyNodeVisitor collector = new CollectingDependencyNodeVisitor();
        FilteringDependencyNodeVisitor filterer = new FilteringDependencyNodeVisitor((DependencyNodeVisitor)collector, includedDeps);
        dependencyNode.accept((DependencyNodeVisitor)filterer);
        return collector.getNodes().stream().map(DependencyNode::getArtifact).collect(Collectors.toList());
    }

    private static boolean isExcluded(Artifact artifact, Collection<Exclusion> exclusions) {
        return exclusions.stream().anyMatch(exclusion -> ScannedDependencyArtifactBuilder.isSameGroupAndArtifactId(exclusion, artifact));
    }

    private static boolean isSameGroupAndArtifactId(Exclusion exclusion, Artifact artifact) {
        return exclusion.getGroupId().equals(artifact.getGroupId()) && exclusion.getArtifactId().equals(artifact.getArtifactId());
    }

    private ScannedDependencyArtifactBuilder() {
    }
}

