/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.performance.tools.virtualusers.measure;

import com.atlassian.performance.tools.virtualusers.api.diagnostics.Diagnostics;
import com.atlassian.performance.tools.virtualusers.measure.ClusterNodeCounter;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import net.jcip.annotations.ThreadSafe;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVPrinter;
import org.apache.commons.csv.CSVRecord;
import org.jetbrains.annotations.NotNull;

@ThreadSafe
@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0001\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0012\u0010\r\u001a\u00020\b2\n\u0010\u000e\u001a\u00060\u000fj\u0002`\u0010J\u0014\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00130\u0012H\u0002J\u001a\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0015\u001a\u00020\u0016J\b\u0010\u0017\u001a\u00020\u0005H\u0016R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/atlassian/performance/tools/virtualusers/measure/ClusterNodeCounter;", "", "()V", "counter", "", "", "Ljava/util/concurrent/atomic/AtomicInteger;", "count", "", "node", "Ljava/util/function/Supplier;", "diagnostics", "Lcom/atlassian/performance/tools/virtualusers/api/diagnostics/Diagnostics;", "dump", "target", "Ljava/lang/Appendable;", "Lkotlin/text/Appendable;", "getResults", "", "", "parse", "reader", "Ljava/io/Reader;", "toString", "virtual-users"})
public final class ClusterNodeCounter {
    private final Map<String, AtomicInteger> counter = new ConcurrentHashMap();

    public final void count(@NotNull Supplier<String> node, @NotNull Diagnostics diagnostics) {
        String string;
        Intrinsics.checkParameterIsNotNull(node, (String)"node");
        Intrinsics.checkParameterIsNotNull((Object)diagnostics, (String)"diagnostics");
        try {
            string = node.get();
        }
        catch (Exception exception) {
            diagnostics.diagnose(exception);
            string = "unknown";
        }
        String nodeId = string;
        this.counter.computeIfAbsent(nodeId, count.1.INSTANCE).incrementAndGet();
    }

    public final void dump(@NotNull Appendable target) {
        Map<String, Integer> $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)target, (String)"target");
        CSVPrinter printer = new CSVPrinter(target, CSVFormat.DEFAULT);
        Map<String, Integer> map = $receiver$iv = this.getResults();
        Iterator<Map.Entry<String, Integer>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, Integer> element$iv;
            Map.Entry<String, Integer> entry = element$iv = iterator.next();
            boolean bl = false;
            printer.print((Object)entry.getKey());
            printer.print((Object)entry.getValue());
            printer.println();
            printer.flush();
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<String, Integer> parse(@NotNull Reader reader) {
        void $receiver$iv$iv;
        void $receiver$iv$iv2;
        Intrinsics.checkParameterIsNotNull((Object)reader, (String)"reader");
        Iterable $receiver$iv = (Iterable)new CSVParser(reader, CSVFormat.DEFAULT);
        Iterable iterable = $receiver$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv2) {
            void record;
            CSVRecord cSVRecord = (CSVRecord)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            void v0 = record;
            Intrinsics.checkExpressionValueIsNotNull((Object)v0, (String)"record");
            List list = CollectionsKt.toList((Iterable)((Iterable)v0));
            collection.add(list);
        }
        $receiver$iv = (List)destination$iv$iv;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10)), (int)16);
        destination$iv$iv = $receiver$iv;
        Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
        for (Object element$iv$iv : $receiver$iv$iv) {
            Map map = destination$iv$iv2;
            List fields = (List)element$iv$iv;
            boolean bl = false;
            String nodeId = (String)fields.get(0);
            Object e = fields.get(1);
            Intrinsics.checkExpressionValueIsNotNull(e, (String)"fields[1]");
            String string = (String)e;
            int count2 = Integer.parseInt(string);
            Pair pair = TuplesKt.to((Object)nodeId, (Object)count2);
            map.put(pair.getFirst(), pair.getSecond());
        }
        return destination$iv$iv2;
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, Integer> getResults() {
        void $receiver$iv$iv;
        Map<String, AtomicInteger> $receiver$iv = this.counter;
        Map<String, AtomicInteger> map = $receiver$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$receiver$iv.size()));
        Iterable $receiver$iv$iv$iv = $receiver$iv$iv.entrySet();
        for (Object element$iv$iv$iv : $receiver$iv$iv$iv) {
            void entry;
            void it$iv$iv;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Map map2 = destination$iv$iv;
            Object k = it$iv$iv.getKey();
            Map.Entry entry3 = (Map.Entry)element$iv$iv$iv;
            Object k2 = k;
            Map map3 = map2;
            boolean bl = false;
            Integer n = ((AtomicInteger)entry.getValue()).intValue();
            map3.put(k2, n);
        }
        return destination$iv$iv;
    }

    @NotNull
    public String toString() {
        return this.getResults().toString();
    }
}

