/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.performance.tools.virtualusers.api.users;

import com.atlassian.data.utils.UserNameUtils;
import com.atlassian.performance.tools.jiraactions.api.memories.User;
import com.atlassian.performance.tools.jvmtasks.api.Backoff;
import com.atlassian.performance.tools.jvmtasks.api.ExponentialBackoff;
import com.atlassian.performance.tools.jvmtasks.api.IdempotentAction;
import com.atlassian.performance.tools.jvmtasks.api.TaskTimer;
import com.atlassian.performance.tools.virtualusers.api.VirtualUserOptions;
import com.atlassian.performance.tools.virtualusers.api.config.VirtualUserTarget;
import com.atlassian.performance.tools.virtualusers.api.users.UserGenerator;
import com.atlassian.performance.tools.virtualusers.api.users.UserNameGenerator;
import java.io.Closeable;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okhttp3.Credentials;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.apache.http.entity.ContentType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000eH\u0002J$\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e0\u00132\u0006\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016R\u0016\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/atlassian/performance/tools/virtualusers/api/users/RestUserGenerator;", "Lcom/atlassian/performance/tools/virtualusers/api/users/UserGenerator;", "()V", "readTimeout", "Ljava/time/Duration;", "(Ljava/time/Duration;)V", "httpClient", "Lokhttp3/OkHttpClient;", "kotlin.jvm.PlatformType", "logger", "Lorg/apache/logging/log4j/Logger;", "nameGenerator", "Lcom/atlassian/performance/tools/virtualusers/api/users/UserNameGenerator;", "createUser", "", "reqBuilder", "Lokhttp3/Request$Builder;", "password", "createUserPayload", "Lkotlin/Pair;", "givenNamesCnt", "", "generateUser", "Lcom/atlassian/performance/tools/jiraactions/api/memories/User;", "options", "Lcom/atlassian/performance/tools/virtualusers/api/VirtualUserOptions;", "virtual-users"})
public final class RestUserGenerator
implements UserGenerator {
    private final UserNameGenerator nameGenerator;
    private final Logger logger;
    private final OkHttpClient httpClient;

    @Override
    @NotNull
    public User generateUser(@NotNull VirtualUserOptions options) {
        Intrinsics.checkParameterIsNotNull((Object)options, (String)"options");
        VirtualUserTarget target = options.getTarget();
        String credential = Credentials.basic((String)target.getUserName$virtual_users(), (String)target.getPassword$virtual_users());
        Request.Builder reqBuilder = new Request.Builder().url(target.getWebApplication$virtual_users().resolve("rest/api/2/user").toString()).header("Authorization", credential);
        IdempotentAction idempotentAction = new IdempotentAction("create user via REST", (Function0)new Function0<String>(this, reqBuilder, target){
            final /* synthetic */ RestUserGenerator this$0;
            final /* synthetic */ Request.Builder $reqBuilder;
            final /* synthetic */ VirtualUserTarget $target;

            @NotNull
            public final String invoke() {
                Request.Builder builder = this.$reqBuilder;
                Intrinsics.checkExpressionValueIsNotNull((Object)builder, (String)"reqBuilder");
                return RestUserGenerator.access$createUser(this.this$0, builder, this.$target.getPassword$virtual_users());
            }
            {
                this.this$0 = restUserGenerator;
                this.$reqBuilder = builder;
                this.$target = virtualUserTarget;
                super(0);
            }
        });
        Duration duration = Duration.ofSeconds(1L);
        Intrinsics.checkExpressionValueIsNotNull((Object)duration, (String)"Duration.ofSeconds(1)");
        String userName2 = (String)idempotentAction.retry(5, (Backoff)new ExponentialBackoff(duration, 0.0, 2, null));
        return new User(userName2, target.getPassword$virtual_users());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final String createUser(Request.Builder reqBuilder, String password) {
        void userName2;
        int givenNamesUsedInThisAttempt = this.nameGenerator.getNumberOfGivenNamesToGenerate();
        Pair<String, String> pair = this.createUserPayload(password, givenNamesUsedInThisAttempt);
        String string = (String)pair.component1();
        String payload = (String)pair.component2();
        RequestBody requestBody = RequestBody.create((MediaType)MediaType.parse((String)ContentType.APPLICATION_JSON.toString()), (String)payload);
        Request request = reqBuilder.post(requestBody).build();
        Closeable closeable = (Closeable)TaskTimer.INSTANCE.time("create user via REST", (Function0)new Function0<Response>(this, request, (String)userName2){
            final /* synthetic */ RestUserGenerator this$0;
            final /* synthetic */ Request $request;
            final /* synthetic */ String $userName;

            public final Response invoke() {
                Response response;
                try {
                    response = RestUserGenerator.access$getHttpClient$p(this.this$0).newCall(this.$request).execute();
                }
                catch (Exception e) {
                    RestUserGenerator.access$getLogger$p(this.this$0).error("Could not create user " + this.$userName, (Throwable)e);
                    throw (Throwable)e;
                }
                return response;
            }
            {
                this.this$0 = restUserGenerator;
                this.$request = request;
                this.$userName = string;
                super(0);
            }
        });
        Throwable throwable = null;
        try {
            Response response = (Response)closeable;
            boolean bl = false;
            if (response.code() == 201) {
                this.nameGenerator.onSuccess();
                this.logger.info("Created a new user " + (String)userName2);
                void var14_14 = userName2;
                return var14_14;
            }
            try {
                String string2;
                if (response.code() == 400) {
                    this.nameGenerator.onCollision(givenNamesUsedInThisAttempt);
                    string2 = "assuming name collision";
                } else {
                    string2 = "unknown reason";
                }
                String possibleReason = string2;
                ResponseBody responseBody = response.body();
                String msg = "Failed to create a new user " + (String)userName2 + ", " + possibleReason + ": " + " response code " + response.code() + ',' + " response body [" + (responseBody != null ? responseBody.string() : null) + ']' + response.headers();
                this.logger.error(msg);
                throw (Throwable)new Exception(msg);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    private final Pair<String, String> createUserPayload(String password, int givenNamesCnt) {
        String displayName = this.nameGenerator.pickRandomUnique(givenNamesCnt);
        String userName2 = UserNameUtils.Companion.toUserName(displayName);
        String payload = StringsKt.trimIndent((String)("\n                {\n                    \"name\": \"" + userName2 + "\",\n                    \"password\": \"" + password + "\",\n                    \"emailAddress\": \"" + userName2 + "@jpt-testing.com\",\n                    \"displayName\": \"" + displayName + "\"\n                }\n                "));
        return new Pair((Object)userName2, (Object)payload);
    }

    public RestUserGenerator(@NotNull Duration readTimeout) {
        Intrinsics.checkParameterIsNotNull((Object)readTimeout, (String)"readTimeout");
        this.nameGenerator = new UserNameGenerator();
        Logger logger = LogManager.getLogger(this.getClass());
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"LogManager.getLogger(this::class.java)");
        this.logger = logger;
        this.httpClient = new OkHttpClient.Builder().readTimeout(readTimeout.getSeconds(), TimeUnit.SECONDS).build();
    }

    public RestUserGenerator() {
        Duration duration = Duration.ofSeconds(90L);
        Intrinsics.checkExpressionValueIsNotNull((Object)duration, (String)"Duration.ofSeconds(90)");
        this(duration);
    }

    public static final /* synthetic */ String access$createUser(RestUserGenerator $this, Request.Builder reqBuilder, String password) {
        return $this.createUser(reqBuilder, password);
    }

    public static final /* synthetic */ OkHttpClient access$getHttpClient$p(RestUserGenerator $this) {
        return $this.httpClient;
    }

    public static final /* synthetic */ Logger access$getLogger$p(RestUserGenerator $this) {
        return $this.logger;
    }
}

