/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.performance.tools.virtualusers.api;

import com.atlassian.performance.tools.jiraactions.api.scenario.Scenario;
import com.atlassian.performance.tools.jirasoftwareactions.api.JiraSoftwareScenario;
import com.atlassian.performance.tools.virtualusers.GoogleChromeWithInsecureConnectionSupport;
import com.atlassian.performance.tools.virtualusers.api.TemporalRate;
import com.atlassian.performance.tools.virtualusers.api.VirtualUserLoad;
import com.atlassian.performance.tools.virtualusers.api.browsers.Browser;
import com.atlassian.performance.tools.virtualusers.api.browsers.HeadlessChromeBrowser;
import com.atlassian.performance.tools.virtualusers.api.config.VirtualUserBehavior;
import com.atlassian.performance.tools.virtualusers.api.config.VirtualUserTarget;
import com.atlassian.performance.tools.virtualusers.api.load.LoadProcess;
import com.atlassian.performance.tools.virtualusers.api.users.RestUserGenerator;
import com.atlassian.performance.tools.virtualusers.api.users.UserGenerator;
import java.lang.reflect.Constructor;
import java.net.URI;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ReplaceWith;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.logging.log4j.core.config.AbstractConfiguration;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\"\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0007\u0018\u0000 D2\u00020\u0001:\u0002DEBi\b\u0017\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0007\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u0012\u0010\b\u0002\u0010\u000b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\r0\f\u0012\b\b\u0002\u0010\u000e\u001a\u00020\u000f\u0012\b\b\u0002\u0010\u0010\u001a\u00020\u0011\u0012\b\b\u0002\u0010\u0012\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0013B_\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u000e\u0010\u000b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\r0\f\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u000e\u0010\u0014\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00150\f\u00a2\u0006\u0002\u0010\u0016B\u0015\u0012\u0006\u0010\u0017\u001a\u00020\u0018\u0012\u0006\u0010\u0019\u001a\u00020\u001a\u00a2\u0006\u0002\u0010\u001bJ\b\u0010;\u001a\u00020\u0003H\u0007J\u0006\u0010<\u001a\u00020=J\u0011\u0010>\u001a\b\u0012\u0004\u0012\u00020\u00070?\u00a2\u0006\u0002\u0010@J\b\u0010A\u001a\u00020\u0005H\u0002J\u000e\u0010B\u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020\u001aJ\u000e\u0010C\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u0018R\u001a\u0010\u0006\u001a\u00020\u00078FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u001c\u0010\u001d\u001a\u0004\b\u001e\u0010\u001fR\u001a\u0010\b\u001a\u00020\u00078FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b \u0010\u001d\u001a\u0004\b!\u0010\u001fR\u0011\u0010\u0019\u001a\u00020\u001a\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\"\u0010\u0014\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00150\f8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b$\u0010\u001d\u001a\u0004\b%\u0010&R\u001a\u0010\u0010\u001a\u00020\u00118FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b'\u0010\u001d\u001a\u0004\b(\u0010)R\u001a\u0010\u0002\u001a\u00020\u00038FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b*\u0010\u001d\u001a\u0004\b+\u0010,R\u001a\u0010\u0004\u001a\u00020\u00058FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b-\u0010\u001d\u001a\u0004\b.\u0010/R\u000e\u00100\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u000b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\r0\f8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b1\u0010\u001d\u001a\u0004\b2\u0010&R\u001a\u0010\u000e\u001a\u00020\u000f8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b3\u0010\u001d\u001a\u0004\b4\u00105R\u0011\u0010\u0017\u001a\u00020\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b6\u00107R\u001a\u0010\t\u001a\u00020\n8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b8\u0010\u001d\u001a\u0004\b9\u0010:\u00a8\u0006F"}, d2={"Lcom/atlassian/performance/tools/virtualusers/api/VirtualUserOptions;", "", "help", "", "jiraAddress", "Ljava/net/URI;", "adminLogin", "", "adminPassword", "virtualUserLoad", "Lcom/atlassian/performance/tools/virtualusers/api/VirtualUserLoad;", "scenario", "Ljava/lang/Class;", "Lcom/atlassian/performance/tools/jiraactions/api/scenario/Scenario;", "seed", "", "diagnosticsLimit", "", "allowInsecureConnections", "(ZLjava/net/URI;Ljava/lang/String;Ljava/lang/String;Lcom/atlassian/performance/tools/virtualusers/api/VirtualUserLoad;Ljava/lang/Class;JIZ)V", "browser", "Lcom/atlassian/performance/tools/virtualusers/api/browsers/Browser;", "(ZLjava/net/URI;Ljava/lang/String;Ljava/lang/String;Lcom/atlassian/performance/tools/virtualusers/api/VirtualUserLoad;Ljava/lang/Class;JILjava/lang/Class;)V", "target", "Lcom/atlassian/performance/tools/virtualusers/api/config/VirtualUserTarget;", "behavior", "Lcom/atlassian/performance/tools/virtualusers/api/config/VirtualUserBehavior;", "(Lcom/atlassian/performance/tools/virtualusers/api/config/VirtualUserTarget;Lcom/atlassian/performance/tools/virtualusers/api/config/VirtualUserBehavior;)V", "adminLogin$annotations", "()V", "getAdminLogin", "()Ljava/lang/String;", "adminPassword$annotations", "getAdminPassword", "getBehavior", "()Lcom/atlassian/performance/tools/virtualusers/api/config/VirtualUserBehavior;", "browser$annotations", "getBrowser", "()Ljava/lang/Class;", "diagnosticsLimit$annotations", "getDiagnosticsLimit", "()I", "help$annotations", "getHelp", "()Z", "jiraAddress$annotations", "getJiraAddress", "()Ljava/net/URI;", "normalizedJiraAddress", "scenario$annotations", "getScenario", "seed$annotations", "getSeed", "()J", "getTarget", "()Lcom/atlassian/performance/tools/virtualusers/api/config/VirtualUserTarget;", "virtualUserLoad$annotations", "getVirtualUserLoad", "()Lcom/atlassian/performance/tools/virtualusers/api/VirtualUserLoad;", "getAllowInsecureConnections", "printHelp", "", "toCliArgs", "", "()[Ljava/lang/String;", "validateJiraAddress", "withBehavior", "withTarget", "Companion", "Parser", "virtual-users"})
public final class VirtualUserOptions {
    private final URI normalizedJiraAddress;
    @NotNull
    private final VirtualUserTarget target;
    @NotNull
    private final VirtualUserBehavior behavior;
    @NotNull
    public static final String helpParameter = "help";
    @NotNull
    public static final String resultsParameter = "results";
    @NotNull
    public static final String jiraAddressParameter = "jira-address";
    @NotNull
    public static final String loginParameter = "login";
    @NotNull
    public static final String passwordParameter = "password";
    @NotNull
    public static final String virtualUsersParameter = "virtual-users";
    @NotNull
    public static final String loggingParameter = "logging";
    @NotNull
    public static final String holdParameter = "hold";
    @NotNull
    public static final String rampParameter = "ramp";
    @NotNull
    public static final String flatParameter = "flat";
    @NotNull
    public static final String maxOverallLoadParameter = "max-overall-load";
    @NotNull
    public static final String scenarioParameter = "scenario";
    @NotNull
    public static final String loadProcessParameter = "load-process";
    @NotNull
    public static final String browserParameter = "browser";
    @NotNull
    public static final String seedParameter = "seed";
    @NotNull
    public static final String diagnosticsLimitParameter = "diagnostics-limit";
    @NotNull
    public static final String allowInsecureConnectionsParameter = "allow-insecure-connections";
    @NotNull
    public static final String skipSetupParameter = "skip-setup";
    @NotNull
    public static final String createUsersParameter = "create-users";
    @NotNull
    public static final String userGeneratorParameter = "user-generator";
    @NotNull
    private static final Options options;
    public static final Companion Companion;

    @Deprecated(message="Raise a JPERF Jira story to explain why you need access to this field")
    public static /* synthetic */ void help$annotations() {
    }

    public final boolean getHelp() {
        return this.behavior.getHelp$virtual_users();
    }

    @Deprecated(message="Raise a JPERF Jira story to explain why you need access to this field")
    public static /* synthetic */ void jiraAddress$annotations() {
    }

    @NotNull
    public final URI getJiraAddress() {
        return this.target.getWebApplication$virtual_users();
    }

    @Deprecated(message="Raise a JPERF Jira story to explain why you need access to this field")
    public static /* synthetic */ void adminLogin$annotations() {
    }

    @NotNull
    public final String getAdminLogin() {
        return this.target.getUserName$virtual_users();
    }

    @Deprecated(message="Raise a JPERF Jira story to explain why you need access to this field")
    public static /* synthetic */ void adminPassword$annotations() {
    }

    @NotNull
    public final String getAdminPassword() {
        return this.target.getPassword$virtual_users();
    }

    @Deprecated(message="This field moved to VirtualUserBehavior", replaceWith=@ReplaceWith(imports={}, expression="behavior.load"))
    public static /* synthetic */ void virtualUserLoad$annotations() {
    }

    @NotNull
    public final VirtualUserLoad getVirtualUserLoad() {
        return this.behavior.getLoad();
    }

    @Deprecated(message="Raise a JPERF Jira story to explain why you need access to this field")
    public static /* synthetic */ void scenario$annotations() {
    }

    @NotNull
    public final Class<? extends Scenario> getScenario() {
        return this.behavior.getScenario$virtual_users();
    }

    @Deprecated(message="Raise a JPERF Jira story to explain why you need access to this field")
    public static /* synthetic */ void seed$annotations() {
    }

    public final long getSeed() {
        return this.behavior.getSeed();
    }

    @Deprecated(message="Raise a JPERF Jira story to explain why you need access to this field")
    public static /* synthetic */ void diagnosticsLimit$annotations() {
    }

    public final int getDiagnosticsLimit() {
        return this.behavior.getDiagnosticsLimit$virtual_users();
    }

    @Deprecated(message="Raise a JPERF Jira story to explain why you need access to this field")
    public static /* synthetic */ void browser$annotations() {
    }

    @NotNull
    public final Class<? extends Browser> getBrowser() {
        return this.behavior.getBrowser$virtual_users();
    }

    @NotNull
    public final VirtualUserOptions withTarget(@NotNull VirtualUserTarget target) {
        Intrinsics.checkParameterIsNotNull((Object)target, (String)"target");
        return new VirtualUserOptions(target, this.behavior);
    }

    @NotNull
    public final VirtualUserOptions withBehavior(@NotNull VirtualUserBehavior behavior) {
        Intrinsics.checkParameterIsNotNull((Object)behavior, (String)"behavior");
        return new VirtualUserOptions(this.target, behavior);
    }

    @Deprecated(message="You can configure browser options by implementing Browser SPI")
    public final boolean getAllowInsecureConnections() {
        return Intrinsics.areEqual(this.behavior.getBrowser$virtual_users(), GoogleChromeWithInsecureConnectionSupport.class);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String[] toCliArgs() {
        void $receiver$iv$iv;
        Map it;
        Map.Entry entry;
        TemporalRate $receiver$iv$iv2;
        void $receiver$iv$iv$iv;
        Map $receiver$iv = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)helpParameter, (Object)this.behavior.getHelp$virtual_users()), TuplesKt.to((Object)allowInsecureConnectionsParameter, (Object)this.getAllowInsecureConnections()), TuplesKt.to((Object)skipSetupParameter, (Object)this.behavior.getSkipSetup$virtual_users())});
        Map map = $receiver$iv;
        Object destination$iv$iv = new ArrayList();
        void var6_7 = $receiver$iv$iv$iv = $receiver$iv$iv2;
        Iterator iterator = var6_7.entrySet().iterator();
        while (iterator.hasNext()) {
            String string;
            void parameter;
            Map.Entry element$iv$iv$iv;
            Map.Entry element$iv$iv;
            Map.Entry $dstr$parameter$value = element$iv$iv = (element$iv$iv$iv = iterator.next());
            boolean bl = false;
            entry = $dstr$parameter$value;
            String string2 = (String)entry.getKey();
            entry = $dstr$parameter$value;
            boolean value = (Boolean)entry.getValue();
            String string3 = value ? "--" + (String)parameter : null;
            if (string3 == null) continue;
            String it$iv$iv = string = string3;
            destination$iv$iv.add(it$iv$iv);
        }
        List flags = (List)destination$iv$iv;
        Pair[] pairArray = new Pair[16];
        pairArray[0] = TuplesKt.to((Object)resultsParameter, (Object)this.behavior.getResults$virtual_users());
        pairArray[1] = TuplesKt.to((Object)jiraAddressParameter, (Object)this.normalizedJiraAddress);
        pairArray[2] = TuplesKt.to((Object)loginParameter, (Object)this.target.getUserName$virtual_users());
        pairArray[3] = TuplesKt.to((Object)passwordParameter, (Object)this.target.getPassword$virtual_users());
        pairArray[4] = TuplesKt.to((Object)virtualUsersParameter, (Object)this.behavior.getLoad().getVirtualUsers());
        pairArray[5] = TuplesKt.to((Object)loggingParameter, (Object)this.behavior.getLogging$virtual_users().getCanonicalName());
        pairArray[6] = TuplesKt.to((Object)holdParameter, (Object)this.behavior.getLoad().getHold());
        pairArray[7] = TuplesKt.to((Object)rampParameter, (Object)this.behavior.getLoad().getRamp());
        pairArray[8] = TuplesKt.to((Object)flatParameter, (Object)this.behavior.getLoad().getFlat());
        $receiver$iv$iv2 = this.behavior.getLoad().getMaxOverallLoad();
        destination$iv$iv = $receiver$iv$iv2;
        String string = maxOverallLoadParameter;
        int n = 9;
        Pair[] pairArray2 = pairArray;
        Pair[] pairArray3 = pairArray;
        boolean bl = false;
        String string4 = "" + ((TemporalRate)((Object)it)).getChange() + '/' + ((TemporalRate)((Object)it)).getTime();
        pairArray2[n] = TuplesKt.to((Object)string, (Object)string4);
        Pair[] pairArray4 = pairArray3;
        pairArray3[10] = TuplesKt.to((Object)scenarioParameter, (Object)this.behavior.getScenario$virtual_users().getCanonicalName());
        pairArray4[11] = TuplesKt.to((Object)loadProcessParameter, (Object)this.behavior.getLoadProcess$virtual_users().getCanonicalName());
        pairArray4[12] = TuplesKt.to((Object)diagnosticsLimitParameter, (Object)this.behavior.getDiagnosticsLimit$virtual_users());
        pairArray4[13] = TuplesKt.to((Object)seedParameter, (Object)this.behavior.getSeed());
        pairArray4[14] = TuplesKt.to((Object)browserParameter, (Object)this.behavior.getBrowser$virtual_users().getName());
        pairArray4[15] = TuplesKt.to((Object)userGeneratorParameter, (Object)this.behavior.getUserGenerator$virtual_users().getName());
        Object $receiver$iv2 = MapsKt.mapOf((Pair[])pairArray4);
        it = $receiver$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        var6_7 = $receiver$iv$iv;
        iterator = var6_7.entrySet().iterator();
        while (iterator.hasNext()) {
            void parameter;
            Map.Entry element$iv$iv;
            Map.Entry $dstr$parameter$value = element$iv$iv = iterator.next();
            boolean bl2 = false;
            Map.Entry entry2 = $dstr$parameter$value;
            entry = (String)entry2.getKey();
            entry2 = $dstr$parameter$value;
            Comparable value = (Comparable)entry2.getValue();
            Iterable list$iv$iv = CollectionsKt.listOf((Object[])new String[]{"--" + (String)parameter, value.toString()});
            CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
        }
        List parameters = (List)destination$iv$iv2;
        Object object = $receiver$iv2 = (Collection)CollectionsKt.plus((Collection)flags, (Iterable)parameters);
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
        }
        Object thisCollection$iv = object;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        if (stringArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        return stringArray;
    }

    private final URI validateJiraAddress() {
        URL url;
        URL uRL;
        try {
            uRL = this.target.getWebApplication$virtual_users().toURL();
        }
        catch (Exception e) {
            throw (Throwable)new Exception("Invalid Jira URL: " + this.target.getWebApplication$virtual_users(), e);
        }
        URL uRL2 = url = uRL;
        Intrinsics.checkExpressionValueIsNotNull((Object)uRL2, (String)"url");
        String string = uRL2.getProtocol();
        String string2 = url.getHost();
        int n = url.getPort();
        String string3 = url.getFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"url.file");
        URI uRI = new URL(string, string2, n, StringsKt.endsWith$default((String)string3, (String)"/", (boolean)false, (int)2, null) ? url.getFile() : url.getFile() + "/", null).toURI();
        Intrinsics.checkExpressionValueIsNotNull((Object)uRI, (String)"URL(\n            url.pro\u2026   null\n        ).toURI()");
        return uRI;
    }

    public final void printHelp() {
        new HelpFormatter().printHelp("EntryPoint", options);
    }

    @NotNull
    public final VirtualUserTarget getTarget() {
        return this.target;
    }

    @NotNull
    public final VirtualUserBehavior getBehavior() {
        return this.behavior;
    }

    public VirtualUserOptions(@NotNull VirtualUserTarget target, @NotNull VirtualUserBehavior behavior) {
        Intrinsics.checkParameterIsNotNull((Object)target, (String)"target");
        Intrinsics.checkParameterIsNotNull((Object)behavior, (String)"behavior");
        this.target = target;
        this.behavior = behavior;
        this.normalizedJiraAddress = this.validateJiraAddress();
    }

    @Deprecated(message="Use the 2-arg constructor. Kotlin defaults don't work from Java and introduce binary compatibility problems. Moreover, forcing to think about the values exposes the powerful options at the users disposal.")
    public VirtualUserOptions(boolean help, @NotNull URI jiraAddress, @NotNull String adminLogin, @NotNull String adminPassword, @NotNull VirtualUserLoad virtualUserLoad, @NotNull Class<? extends Scenario> scenario, long seed, int diagnosticsLimit, boolean allowInsecureConnections) {
        Intrinsics.checkParameterIsNotNull((Object)jiraAddress, (String)"jiraAddress");
        Intrinsics.checkParameterIsNotNull((Object)adminLogin, (String)"adminLogin");
        Intrinsics.checkParameterIsNotNull((Object)adminPassword, (String)"adminPassword");
        Intrinsics.checkParameterIsNotNull((Object)virtualUserLoad, (String)"virtualUserLoad");
        Intrinsics.checkParameterIsNotNull(scenario, (String)scenarioParameter);
        this(help, jiraAddress, adminLogin, adminPassword, virtualUserLoad, scenario, seed, diagnosticsLimit, allowInsecureConnections ? GoogleChromeWithInsecureConnectionSupport.class : HeadlessChromeBrowser.class);
    }

    public /* synthetic */ VirtualUserOptions(boolean bl, URI uRI, String string, String string2, VirtualUserLoad virtualUserLoad, Class clazz, long l, int n, boolean bl2, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            bl = false;
        }
        if ((n2 & 2) != 0) {
            uRI = new URI("http://localhost:8080/");
        }
        if ((n2 & 4) != 0) {
            string = "admin";
        }
        if ((n2 & 8) != 0) {
            string2 = "admin";
        }
        if ((n2 & 0x10) != 0) {
            virtualUserLoad = new VirtualUserLoad(0, null, null, null, 15, null);
        }
        if ((n2 & 0x20) != 0) {
            clazz = JiraSoftwareScenario.class;
        }
        if ((n2 & 0x40) != 0) {
            l = new Random().nextLong();
        }
        if ((n2 & 0x80) != 0) {
            n = 64;
        }
        if ((n2 & 0x100) != 0) {
            bl2 = false;
        }
        this(bl, uRI, string, string2, virtualUserLoad, clazz, l, n, bl2);
    }

    @Deprecated(message="Use the 2-arg constructor")
    public VirtualUserOptions(boolean help, @NotNull URI jiraAddress, @NotNull String adminLogin, @NotNull String adminPassword, @NotNull VirtualUserLoad virtualUserLoad, @NotNull Class<? extends Scenario> scenario, long seed, int diagnosticsLimit, @NotNull Class<? extends Browser> browser) {
        Intrinsics.checkParameterIsNotNull((Object)jiraAddress, (String)"jiraAddress");
        Intrinsics.checkParameterIsNotNull((Object)adminLogin, (String)"adminLogin");
        Intrinsics.checkParameterIsNotNull((Object)adminPassword, (String)"adminPassword");
        Intrinsics.checkParameterIsNotNull((Object)virtualUserLoad, (String)"virtualUserLoad");
        Intrinsics.checkParameterIsNotNull(scenario, (String)scenarioParameter);
        Intrinsics.checkParameterIsNotNull(browser, (String)browserParameter);
        this(new VirtualUserTarget(jiraAddress, adminLogin, adminPassword), new VirtualUserBehavior.Builder(scenario).load(virtualUserLoad).seed(seed).diagnosticsLimit(diagnosticsLimit).browser(browser).build());
    }

    static {
        Companion = new Companion(null);
        Options options = new Options().addOption(Option.builder((String)"h").longOpt(helpParameter).desc("This help").build()).addOption(Option.builder().longOpt(resultsParameter).hasArg().argName(resultsParameter).desc("Path to the target results directory").build()).addOption(Option.builder().longOpt(jiraAddressParameter).hasArg().argName("address").desc("Address of tested JIRA as URI").required().build()).addOption(Option.builder().longOpt(loginParameter).hasArg().desc("Login of an admin user").required().build()).addOption(Option.builder().longOpt(passwordParameter).hasArg().desc("Password of an admin user").required().build()).addOption(Option.builder().longOpt(virtualUsersParameter).hasArg(true).desc("Number of virtual users to execute.").required().build()).addOption(Option.builder().longOpt(loggingParameter).hasArg().desc("Custom logging configuration").build()).addOption(Option.builder().longOpt(holdParameter).hasArg().desc("Initial hold duration in ISO-8601 format").required().build()).addOption(Option.builder().longOpt(rampParameter).hasArg().desc("Load ramp duration in ISO-8601 format").required().build()).addOption(Option.builder().longOpt(flatParameter).hasArg().desc("Flat load duration in ISO-8601 format").required().build()).addOption(Option.builder().longOpt(maxOverallLoadParameter).hasArg().desc("Maximum action rate for each VU throughout the entire duration. Format: <decimal real number>/<ISO-8601 duration>").build()).addOption(Option.builder().longOpt(scenarioParameter).hasArg(true).desc("Custom scenario").build()).addOption(Option.builder().longOpt(loadProcessParameter).hasArg(true).desc("Custom load process").build()).addOption(Option.builder().longOpt(browserParameter).hasArg(true).desc("Custom browser").build()).addOption(Option.builder().longOpt(seedParameter).hasArg(true).desc("Root seed.").required().build()).addOption(Option.builder().longOpt(diagnosticsLimitParameter).hasArg().desc("Limiting how many times diagnostics can be executed").required().build()).addOption(Option.builder().longOpt(allowInsecureConnectionsParameter).desc("Allows insecure connections to the browser").build()).addOption(Option.builder().longOpt(skipSetupParameter).desc("Skips the setup action").build()).addOption(Option.builder().longOpt(createUsersParameter).desc("Creates users").build()).addOption(Option.builder().longOpt(userGeneratorParameter).hasArg(true).desc("Users generator class").build());
        Intrinsics.checkExpressionValueIsNotNull((Object)options, (String)"Options()\n            .a\u2026   .build()\n            )");
        VirtualUserOptions.options = options;
    }

    @Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u001a\u0010\u0007\u001a\f\u0012\u0006\b\u0001\u0012\u00020\t\u0018\u00010\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0018\u0010\n\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u001a\u0010\f\u001a\f\u0012\u0006\b\u0001\u0012\u00020\r\u0018\u00010\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0018\u0010\u0010\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00110\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u001a\u0010\u0012\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0013\u0018\u00010\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0019\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017\u00a2\u0006\u0002\u0010\u0019\u00a8\u0006\u001a"}, d2={"Lcom/atlassian/performance/tools/virtualusers/api/VirtualUserOptions$Parser;", "", "()V", "buildBehavior", "Lcom/atlassian/performance/tools/virtualusers/api/config/VirtualUserBehavior$Builder;", "commandLine", "Lorg/apache/commons/cli/CommandLine;", "getBrowser", "Ljava/lang/Class;", "Lcom/atlassian/performance/tools/virtualusers/api/browsers/Browser;", "getLoadProcess", "Lcom/atlassian/performance/tools/virtualusers/api/load/LoadProcess;", "getLogging", "Lorg/apache/logging/log4j/core/config/AbstractConfiguration;", "getMaxOverallLoad", "Lcom/atlassian/performance/tools/virtualusers/api/TemporalRate;", "getScenario", "Lcom/atlassian/performance/tools/jiraactions/api/scenario/Scenario;", "getUserGenerator", "Lcom/atlassian/performance/tools/virtualusers/api/users/UserGenerator;", "parse", "Lcom/atlassian/performance/tools/virtualusers/api/VirtualUserOptions;", "args", "", "", "([Ljava/lang/String;)Lcom/atlassian/performance/tools/virtualusers/api/VirtualUserOptions;", "virtual-users"})
    public static final class Parser {
        @NotNull
        public final VirtualUserOptions parse(@NotNull String[] args) {
            Object it;
            VirtualUserOptions virtualUserOptions;
            Path path;
            Intrinsics.checkParameterIsNotNull((Object)args, (String)"args");
            CommandLineParser parser = (CommandLineParser)new DefaultParser();
            CommandLine commandLine = parser.parse(Companion.getOptions(), args);
            URI jiraAddress = new URI(commandLine.getOptionValue(VirtualUserOptions.jiraAddressParameter));
            String adminLogin = commandLine.getOptionValue(VirtualUserOptions.loginParameter);
            String adminPassword = commandLine.getOptionValue(VirtualUserOptions.passwordParameter);
            String string = commandLine.getOptionValue(VirtualUserOptions.virtualUsersParameter);
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"commandLine.getOptionValue(virtualUsersParameter)");
            String string2 = string;
            int virtualUsers = Integer.parseInt(string2);
            Duration hold = Duration.parse(commandLine.getOptionValue(VirtualUserOptions.holdParameter));
            Duration ramp = Duration.parse(commandLine.getOptionValue(VirtualUserOptions.rampParameter));
            Duration flat = Duration.parse(commandLine.getOptionValue(VirtualUserOptions.flatParameter));
            CommandLine commandLine2 = commandLine;
            Intrinsics.checkExpressionValueIsNotNull((Object)commandLine2, (String)"commandLine");
            TemporalRate maxOverallLoad = this.getMaxOverallLoad(commandLine2);
            String string3 = commandLine.getOptionValue(VirtualUserOptions.diagnosticsLimitParameter);
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"commandLine.getOptionVal\u2026iagnosticsLimitParameter)");
            String string4 = string3;
            int diagnosticsLimit = Integer.parseInt(string4);
            String string5 = commandLine.getOptionValue(VirtualUserOptions.seedParameter);
            Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"commandLine.getOptionValue(seedParameter)");
            String string6 = string5;
            long seed = Long.parseLong(string6);
            boolean skipSetup = commandLine.hasOption(VirtualUserOptions.skipSetupParameter);
            boolean createUsers = commandLine.hasOption(VirtualUserOptions.createUsersParameter);
            String string7 = commandLine.getOptionValue(VirtualUserOptions.resultsParameter);
            if (string7 != null) {
                String string8;
                String it2 = string8 = string7;
                boolean bl = false;
                path = Paths.get(it2, new String[0]);
            } else {
                path = null;
            }
            Path results = path;
            Class<? extends Browser> browser = this.getBrowser(commandLine);
            Class<? extends AbstractConfiguration> logging = this.getLogging(commandLine);
            Class<RestUserGenerator> userGenerator = createUsers ? RestUserGenerator.class : this.getUserGenerator(commandLine);
            String string9 = adminLogin;
            Intrinsics.checkExpressionValueIsNotNull((Object)string9, (String)"adminLogin");
            String string10 = adminPassword;
            Intrinsics.checkExpressionValueIsNotNull((Object)string10, (String)"adminPassword");
            VirtualUserTarget virtualUserTarget = new VirtualUserTarget(jiraAddress, string9, string10);
            VirtualUserBehavior.Builder builder = this.buildBehavior(commandLine).diagnosticsLimit(diagnosticsLimit).seed(seed);
            VirtualUserLoad.Builder builder2 = new VirtualUserLoad.Builder().virtualUsers(virtualUsers);
            Duration duration = hold;
            Intrinsics.checkExpressionValueIsNotNull((Object)duration, (String)VirtualUserOptions.holdParameter);
            VirtualUserLoad.Builder builder3 = builder2.hold(duration);
            Duration duration2 = ramp;
            Intrinsics.checkExpressionValueIsNotNull((Object)duration2, (String)VirtualUserOptions.rampParameter);
            VirtualUserLoad.Builder builder4 = builder3.ramp(duration2);
            Duration duration3 = flat;
            Intrinsics.checkExpressionValueIsNotNull((Object)duration3, (String)VirtualUserOptions.flatParameter);
            Object object = builder4.flat(duration3);
            VirtualUserLoad.Builder builder5 = object;
            VirtualUserBehavior.Builder builder6 = builder;
            VirtualUserTarget virtualUserTarget2 = virtualUserTarget;
            VirtualUserOptions virtualUserOptions2 = virtualUserOptions;
            VirtualUserOptions virtualUserOptions3 = virtualUserOptions;
            boolean bl = false;
            if (maxOverallLoad != null) {
                ((VirtualUserLoad.Builder)it).maxOverallLoad(maxOverallLoad);
            }
            Unit unit = Unit.INSTANCE;
            it = object = builder6.load(((VirtualUserLoad.Builder)object).build()).skipSetup(skipSetup);
            boolean bl2 = false;
            if (results != null) {
                ((VirtualUserBehavior.Builder)it).results(results);
            }
            builder6 = Unit.INSTANCE;
            it = object;
            boolean bl3 = false;
            if (browser != null) {
                ((VirtualUserBehavior.Builder)it).browser(browser);
            }
            builder6 = Unit.INSTANCE;
            it = object;
            boolean bl4 = false;
            if (logging != null) {
                ((VirtualUserBehavior.Builder)it).logging(logging);
            }
            builder6 = Unit.INSTANCE;
            it = object;
            boolean bl5 = false;
            if (userGenerator != null) {
                ((VirtualUserBehavior.Builder)it).userGenerator(userGenerator);
            }
            builder6 = Unit.INSTANCE;
            virtualUserOptions2(virtualUserTarget2, ((VirtualUserBehavior.Builder)object).build());
            return virtualUserOptions3;
        }

        private final VirtualUserBehavior.Builder buildBehavior(CommandLine commandLine) {
            VirtualUserBehavior.Builder builder = new VirtualUserBehavior.Builder();
            if (commandLine.hasOption(VirtualUserOptions.loadProcessParameter)) {
                builder.loadProcess(this.getLoadProcess(commandLine));
            }
            if (commandLine.hasOption(VirtualUserOptions.scenarioParameter)) {
                builder.scenario(this.getScenario(commandLine));
            }
            return builder;
        }

        private final Class<? extends LoadProcess> getLoadProcess(CommandLine commandLine) {
            String loadProcess = commandLine.getOptionValue(VirtualUserOptions.loadProcessParameter);
            Class<?> loadProcessClass = Class.forName(loadProcess);
            Constructor<?> loadProcessConstructor = loadProcessClass.getConstructor(new Class[0]);
            Object obj = loadProcessConstructor.newInstance(new Object[0]);
            if (obj == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.atlassian.performance.tools.virtualusers.api.load.LoadProcess");
            }
            return ((LoadProcess)obj).getClass();
        }

        private final Class<? extends Scenario> getScenario(CommandLine commandLine) {
            String scenario = commandLine.getOptionValue(VirtualUserOptions.scenarioParameter);
            Class<?> scenarioClass = Class.forName(scenario);
            Constructor<?> scenarioConstructor = scenarioClass.getConstructor(new Class[0]);
            Object obj = scenarioConstructor.newInstance(new Object[0]);
            if (obj == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.atlassian.performance.tools.jiraactions.api.scenario.Scenario");
            }
            return ((Scenario)obj).getClass();
        }

        /*
         * WARNING - void declaration
         */
        private final TemporalRate getMaxOverallLoad(CommandLine commandLine) {
            TemporalRate temporalRate;
            Object object = commandLine.getOptionValue(VirtualUserOptions.maxOverallLoadParameter);
            if (object != null && (object = StringsKt.split$default((CharSequence)((CharSequence)object), (char[])new char[]{'/'}, (boolean)false, (int)0, (int)6, null)) != null) {
                void actions;
                Object object2;
                Object $dstr$actions$time = object2 = object;
                boolean bl = false;
                Object object3 = $dstr$actions$time;
                String string = (String)object3.get(0);
                object3 = $dstr$actions$time;
                String time = (String)object3.get(1);
                object3 = actions;
                double d = Double.parseDouble((String)object3);
                Duration duration = Duration.parse(time);
                Intrinsics.checkExpressionValueIsNotNull((Object)duration, (String)"Duration.parse(time)");
                temporalRate = new TemporalRate(d, duration);
            } else {
                temporalRate = null;
            }
            return temporalRate;
        }

        private final Class<? extends Browser> getBrowser(CommandLine commandLine) {
            Class<?> clazz;
            if (commandLine.hasOption(VirtualUserOptions.browserParameter)) {
                String browser = commandLine.getOptionValue(VirtualUserOptions.browserParameter);
                Class<?> browserClass = Class.forName(browser);
                Constructor<?> browserConstructor = browserClass.getConstructor(new Class[0]);
                Object obj = browserConstructor.newInstance(new Object[0]);
                if (obj == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.atlassian.performance.tools.virtualusers.api.browsers.Browser");
                }
                clazz = ((Browser)obj).getClass();
            } else {
                clazz = null;
            }
            return clazz;
        }

        private final Class<? extends AbstractConfiguration> getLogging(CommandLine commandLine) {
            Class<?> clazz;
            if (commandLine.hasOption(VirtualUserOptions.loggingParameter)) {
                String logging = commandLine.getOptionValue(VirtualUserOptions.loggingParameter);
                Class<?> loggingClass = Class.forName(logging);
                Constructor<?> loggingConstructor = loggingClass.getConstructor(new Class[0]);
                Object obj = loggingConstructor.newInstance(new Object[0]);
                if (obj == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.apache.logging.log4j.core.config.AbstractConfiguration");
                }
                clazz = ((AbstractConfiguration)obj).getClass();
            } else {
                clazz = null;
            }
            return clazz;
        }

        private final Class<? extends UserGenerator> getUserGenerator(CommandLine commandLine) {
            Class<?> clazz;
            if (commandLine.hasOption(VirtualUserOptions.userGeneratorParameter)) {
                String userGenerator = commandLine.getOptionValue(VirtualUserOptions.userGeneratorParameter);
                Class<?> userGeneratorClass = Class.forName(userGenerator);
                Constructor<?> userGeneratorConstructor = userGeneratorClass.getConstructor(new Class[0]);
                Object obj = userGeneratorConstructor.newInstance(new Object[0]);
                if (obj == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.atlassian.performance.tools.virtualusers.api.users.UserGenerator");
                }
                clazz = ((UserGenerator)obj).getClass();
            } else {
                clazz = null;
            }
            return clazz;
        }
    }

    @Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/atlassian/performance/tools/virtualusers/api/VirtualUserOptions$Companion;", "", "()V", "allowInsecureConnectionsParameter", "", "browserParameter", "createUsersParameter", "diagnosticsLimitParameter", "flatParameter", "helpParameter", "holdParameter", "jiraAddressParameter", "loadProcessParameter", "loggingParameter", "loginParameter", "maxOverallLoadParameter", "options", "Lorg/apache/commons/cli/Options;", "getOptions", "()Lorg/apache/commons/cli/Options;", "passwordParameter", "rampParameter", "resultsParameter", "scenarioParameter", "seedParameter", "skipSetupParameter", "userGeneratorParameter", "virtualUsersParameter", "virtual-users"})
    public static final class Companion {
        @NotNull
        public final Options getOptions() {
            return options;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

