/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.performance.tools.virtualusers;

import com.atlassian.performance.tools.jiraactions.api.SeededRandom;
import com.atlassian.performance.tools.jiraactions.api.WebJira;
import com.atlassian.performance.tools.jiraactions.api.action.Action;
import com.atlassian.performance.tools.jiraactions.api.action.LogInAction;
import com.atlassian.performance.tools.jiraactions.api.action.SetUpAction;
import com.atlassian.performance.tools.jiraactions.api.measure.ActionMeter;
import com.atlassian.performance.tools.jiraactions.api.memories.UserMemory;
import com.atlassian.performance.tools.jiraactions.api.scenario.Scenario;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J$\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u001e\u0010\u000e\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0010J\u0016\u0010\u0011\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\rJ\b\u0010\u0012\u001a\u00020\u0013H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/atlassian/performance/tools/virtualusers/ScenarioAdapter;", "", "scenario", "Lcom/atlassian/performance/tools/jiraactions/api/scenario/Scenario;", "(Lcom/atlassian/performance/tools/jiraactions/api/scenario/Scenario;)V", "getActions", "", "Lcom/atlassian/performance/tools/jiraactions/api/action/Action;", "jira", "Lcom/atlassian/performance/tools/jiraactions/api/WebJira;", "seededRandom", "Lcom/atlassian/performance/tools/jiraactions/api/SeededRandom;", "meter", "Lcom/atlassian/performance/tools/jiraactions/api/measure/ActionMeter;", "getLogInAction", "userMemory", "Lcom/atlassian/performance/tools/jiraactions/api/memories/UserMemory;", "getSetupAction", "isScenario3Compatible", "", "virtual-users"})
public final class ScenarioAdapter {
    private final Scenario scenario;

    @NotNull
    public final List<Action> getActions(@NotNull WebJira jira, @NotNull SeededRandom seededRandom, @NotNull ActionMeter meter) {
        Intrinsics.checkParameterIsNotNull((Object)jira, (String)"jira");
        Intrinsics.checkParameterIsNotNull((Object)seededRandom, (String)"seededRandom");
        Intrinsics.checkParameterIsNotNull((Object)meter, (String)"meter");
        List list = this.scenario.getActions(jira, seededRandom, meter);
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"scenario.getActions(jira, seededRandom, meter)");
        return list;
    }

    @NotNull
    public final Action getLogInAction(@NotNull WebJira jira, @NotNull ActionMeter meter, @NotNull UserMemory userMemory) {
        Action action;
        Intrinsics.checkParameterIsNotNull((Object)jira, (String)"jira");
        Intrinsics.checkParameterIsNotNull((Object)meter, (String)"meter");
        Intrinsics.checkParameterIsNotNull((Object)userMemory, (String)"userMemory");
        if (this.isScenario3Compatible()) {
            Method getLogInActionMethod = this.scenario.getClass().getMethod("getLogInAction", WebJira.class, ActionMeter.class, UserMemory.class);
            Object object = getLogInActionMethod.invoke((Object)this.scenario, jira, meter, userMemory);
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.atlassian.performance.tools.jiraactions.api.action.Action");
            }
            action = (Action)object;
        } else {
            action = (Action)new LogInAction(jira, meter, userMemory);
        }
        return action;
    }

    @NotNull
    public final Action getSetupAction(@NotNull WebJira jira, @NotNull ActionMeter meter) {
        Action action;
        Intrinsics.checkParameterIsNotNull((Object)jira, (String)"jira");
        Intrinsics.checkParameterIsNotNull((Object)meter, (String)"meter");
        if (this.isScenario3Compatible()) {
            Method getSetupActionMethod = this.scenario.getClass().getMethod("getSetupAction", WebJira.class, ActionMeter.class);
            Object object = getSetupActionMethod.invoke((Object)this.scenario, jira, meter);
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.atlassian.performance.tools.jiraactions.api.action.Action");
            }
            action = (Action)object;
        } else {
            action = (Action)new SetUpAction(jira, meter);
        }
        return action;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isScenario3Compatible() {
        void $receiver$iv$iv;
        Method[] methodArray = this.scenario.getClass().getMethods();
        Intrinsics.checkExpressionValueIsNotNull((Object)methodArray, (String)"scenario::class\n        \u2026java\n            .methods");
        Method[] $receiver$iv = methodArray;
        Method[] methodArray2 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList($receiver$iv.length);
        int n = ((void)$receiver$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv;
            void var8_7 = item$iv$iv = $receiver$iv$iv[i];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            void v1 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"it");
            String string = v1.getName();
            collection.add(string);
        }
        List methods = (List)destination$iv$iv;
        return methods.contains("getSetupAction") && methods.contains("getLogInAction");
    }

    public ScenarioAdapter(@NotNull Scenario scenario) {
        Intrinsics.checkParameterIsNotNull((Object)scenario, (String)"scenario");
        this.scenario = scenario;
    }
}

