/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.performance.tools.virtualusers;

import com.atlassian.performance.tools.concurrency.api.AbruptExecutorService;
import com.atlassian.performance.tools.concurrency.api.TaskContextKt;
import com.atlassian.performance.tools.jiraactions.api.SeededRandom;
import com.atlassian.performance.tools.virtualusers.LoadTest;
import com.atlassian.performance.tools.virtualusers.LoadThreadWithContainer;
import com.atlassian.performance.tools.virtualusers.api.VirtualUserLoad;
import com.atlassian.performance.tools.virtualusers.api.VirtualUserNodeResult;
import com.atlassian.performance.tools.virtualusers.api.VirtualUserOptions;
import com.atlassian.performance.tools.virtualusers.api.config.LoadProcessContainer;
import com.atlassian.performance.tools.virtualusers.api.config.LoadThreadContainer;
import com.atlassian.performance.tools.virtualusers.api.config.VirtualUserBehavior;
import com.atlassian.performance.tools.virtualusers.api.load.LoadProcess;
import com.atlassian.performance.tools.virtualusers.api.load.LoadThread;
import com.atlassian.performance.tools.virtualusers.api.load.LoadThreadFactory;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0002J\u0006\u0010\f\u001a\u00020\rR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/atlassian/performance/tools/virtualusers/LoadTest;", "", "options", "Lcom/atlassian/performance/tools/virtualusers/api/VirtualUserOptions;", "(Lcom/atlassian/performance/tools/virtualusers/api/VirtualUserOptions;)V", "logger", "Lorg/apache/logging/log4j/Logger;", "close", "", "threads", "", "Lcom/atlassian/performance/tools/virtualusers/LoadThreadWithContainer;", "run", "Lcom/atlassian/performance/tools/virtualusers/api/VirtualUserNodeResult;", "virtual-users"})
public final class LoadTest {
    private final Logger logger;
    private final VirtualUserOptions options;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final VirtualUserNodeResult run() {
        void $receiver$iv$iv;
        VirtualUserBehavior behavior = this.options.getBehavior();
        LoadProcess process = behavior.getLoadProcess$virtual_users().getConstructor(new Class[0]).newInstance(new Object[0]);
        LoadProcessContainer processContainer = LoadProcessContainer.Factory.create(this.options, new VirtualUserNodeResult(behavior.getResults$virtual_users()), new SeededRandom(behavior.getSeed()));
        VirtualUserLoad load = behavior.getLoad();
        Duration finish = load.getRamp().plus(load.getFlat());
        int threadCount = load.getVirtualUsers();
        AtomicInteger threadCounter = new AtomicInteger(0);
        ThreadPoolExecutor pool2 = new ThreadPoolExecutor(threadCount, threadCount, 0L, TimeUnit.MILLISECONDS, (BlockingQueue<Runnable>)new LinkedBlockingQueue(), new ThreadFactory(threadCounter){
            final /* synthetic */ AtomicInteger $threadCounter;

            @NotNull
            public final Thread newThread(Runnable runnable) {
                Object object = "virtual-user-%d";
                Object[] objectArray = new Object[]{this.$threadCounter.incrementAndGet()};
                String string = String.format((String)object, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"java.lang.String.format(this, *args)");
                String name = string;
                Object $receiver = object = new Thread(runnable, name);
                boolean bl = false;
                ((Thread)$receiver).setDaemon(true);
                return object;
            }
            {
                this.$threadCounter = atomicInteger;
            }
        });
        AtomicBoolean stop = new AtomicBoolean(false);
        LoadThreadFactory threadFactory = process.prepareFactory(processContainer);
        int n = 1;
        Iterable $receiver$iv = (Iterable)new IntRange(n, threadCount);
        Iterable iterable = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        Iterator iterator = $receiver$iv$iv.iterator();
        while (iterator.hasNext()) {
            void threadIndex;
            int item$iv$iv;
            int n2 = item$iv$iv = ((IntIterator)iterator).nextInt();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            UUID uUID = UUID.randomUUID();
            Intrinsics.checkExpressionValueIsNotNull((Object)uUID, (String)"UUID.randomUUID()");
            LoadThreadContainer threadContainer = LoadThreadContainer.Factory.create(processContainer, (int)threadIndex, uUID);
            LoadThread readyThread = threadFactory.prepareThread(threadContainer);
            LoadThreadWithContainer loadThreadWithContainer = new LoadThreadWithContainer(readyThread, threadContainer);
            collection.add(loadThreadWithContainer);
        }
        List threads = (List)destination$iv$iv;
        $receiver$iv = threads;
        for (Object element$iv : $receiver$iv) {
            LoadThreadWithContainer thread2 = (LoadThreadWithContainer)element$iv;
            boolean bl = false;
            TaskContextKt.submitWithLogContext((ExecutorService)pool2, (String)thread2.getContainer().getId(), (Function0)((Function0)new Function0<Unit>(thread2, pool2, load, stop){
                final /* synthetic */ LoadThreadWithContainer $thread;
                final /* synthetic */ ThreadPoolExecutor $pool$inlined;
                final /* synthetic */ VirtualUserLoad $load$inlined;
                final /* synthetic */ AtomicBoolean $stop$inlined;
                {
                    this.$thread = loadThreadWithContainer;
                    this.$pool$inlined = threadPoolExecutor;
                    this.$load$inlined = virtualUserLoad;
                    this.$stop$inlined = atomicBoolean;
                    super(0);
                }

                public final void invoke() {
                    Thread.sleep(this.$load$inlined.getHold().toMillis());
                    this.$thread.getLoadThread().generateLoad(this.$stop$inlined);
                }
            }));
        }
        Thread.sleep(finish.toMillis());
        stop.set(true);
        this.close(threads);
        processContainer.close();
        return processContainer.result();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void close(List<LoadThreadWithContainer> threads) {
        this.logger.info("Closing thread containers");
        ExecutorService executorService = Executors.newCachedThreadPool(close.1.INSTANCE);
        Intrinsics.checkExpressionValueIsNotNull((Object)executorService, (String)"newCachedThreadPool { Th\u2026ose-thread-containers\") }");
        AutoCloseable autoCloseable = (AutoCloseable)new AbruptExecutorService(executorService);
        Throwable throwable = null;
        try {
            void $receiver$iv$iv;
            Iterable $receiver$iv;
            AbruptExecutorService pool2 = (AbruptExecutorService)autoCloseable;
            boolean bl = false;
            Iterable iterable = threads;
            Iterator iterator = $receiver$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void it;
                LoadThreadWithContainer loadThreadWithContainer = (LoadThreadWithContainer)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                Future future = pool2.submit(new Runnable((LoadThreadWithContainer)it){
                    final /* synthetic */ LoadThreadWithContainer $it;

                    public final void run() {
                        this.$it.getContainer().close();
                    }
                    {
                        this.$it = loadThreadWithContainer;
                    }
                });
                collection.add(future);
            }
            $receiver$iv = (List)destination$iv$iv;
            for (Object element$iv : $receiver$iv) {
                Future it = (Future)element$iv;
                boolean bl3 = false;
                it.get();
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        this.logger.info("Thread containers closed");
    }

    public LoadTest(@NotNull VirtualUserOptions options) {
        Intrinsics.checkParameterIsNotNull((Object)options, (String)"options");
        this.options = options;
        Logger logger = LogManager.getLogger(this.getClass());
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"LogManager.getLogger(this::class.java)");
        this.logger = logger;
    }
}

