package com.atlassian.oauth2.scopes.api;

import java.util.Objects;

public class ScopeDescriptionWithTitle {

    private final String title;
    private final String description;

    public ScopeDescriptionWithTitle(final String title, final String description) {
        this.title = title;
        this.description = description;
    }

    public String getTitle() {
        return title;
    }

    public String getDescription() {
        return description;
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        final ScopeDescriptionWithTitle that = (ScopeDescriptionWithTitle) o;
        return title.equals(that.title) && description.equals(that.description);
    }

    @Override
    public int hashCode() {
        return Objects.hash(title, description);
    }
}
