package com.atlassian.oauth2.scopes.api;

import java.util.Collection;

public class InvalidScopeException extends RuntimeException {

    public static InvalidScopeException blankScope() {
        return new InvalidScopeException();
    }

    private InvalidScopeException() {
        super("Blank scope");
    }

    public InvalidScopeException(final Collection<String> invalidScopes) {
        super(message(invalidScopes));
    }

    public InvalidScopeException(final Collection<String> invalidScopes, final Throwable cause) {
        super(message(invalidScopes), cause);
    }

    private static String message(final Collection<String> invalidScopes) {
        return String.format("Found invalid scopes [%s]", invalidScopes.toString());
    }
}
