/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.openid.connect.sdk.assurance.evidences;

import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.util.JSONObjectUtils;
import com.nimbusds.oauth2.sdk.util.date.SimpleDate;
import com.nimbusds.openid.connect.sdk.assurance.claims.CountryCode;
import com.nimbusds.openid.connect.sdk.assurance.claims.ISO3166_1Alpha2CountryCode;
import com.nimbusds.openid.connect.sdk.assurance.evidences.IDDocumentType;
import java.util.Objects;
import net.minidev.json.JSONAware;
import net.minidev.json.JSONObject;

public class IDDocumentDescription
implements JSONAware {
    private final IDDocumentType type;
    private final String number;
    private final String issuerName;
    private final CountryCode issuerCountry;
    private final SimpleDate dateOfIssuance;
    private final SimpleDate dateOfExpiry;

    public IDDocumentDescription(IDDocumentType type, String number, String issuerName, CountryCode issuerCountry, SimpleDate dateOfIssuance, SimpleDate dateOfExpiry) {
        if (type == null) {
            throw new IllegalArgumentException("The type must not be null");
        }
        this.type = type;
        if (number == null) {
            throw new IllegalArgumentException("The number must not be null");
        }
        this.number = number;
        if (issuerName == null) {
            throw new IllegalArgumentException("The issuer name must not be null");
        }
        this.issuerName = issuerName;
        if (issuerCountry == null) {
            throw new IllegalArgumentException("The issuer country must not be null");
        }
        this.issuerCountry = issuerCountry;
        if (dateOfIssuance == null) {
            throw new IllegalArgumentException("The date of issuance must not be null");
        }
        this.dateOfIssuance = dateOfIssuance;
        if (dateOfExpiry == null) {
            throw new IllegalArgumentException("The date of expiry must not be null");
        }
        this.dateOfExpiry = dateOfExpiry;
    }

    public IDDocumentType getType() {
        return this.type;
    }

    public String getNumber() {
        return this.number;
    }

    public String getIssuerName() {
        return this.issuerName;
    }

    public CountryCode getIssuerCountry() {
        return this.issuerCountry;
    }

    public SimpleDate getDateOfIssuance() {
        return this.dateOfIssuance;
    }

    public SimpleDate getDateOfExpiry() {
        return this.dateOfExpiry;
    }

    public JSONObject toJSONObject() {
        JSONObject o = new JSONObject();
        o.put("type", this.getType().getValue());
        o.put("number", this.getNumber());
        JSONObject issuerObject = new JSONObject();
        issuerObject.put("name", this.getIssuerName());
        issuerObject.put("country", this.getIssuerCountry().getValue());
        o.put("issuer", issuerObject);
        o.put("date_of_issuance", this.getDateOfIssuance().toISO8601String());
        o.put("date_of_expiry", this.getDateOfExpiry().toISO8601String());
        return o;
    }

    @Override
    public String toJSONString() {
        return this.toJSONObject().toJSONString();
    }

    public String toString() {
        return this.toJSONString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IDDocumentDescription)) {
            return false;
        }
        IDDocumentDescription that = (IDDocumentDescription)o;
        return this.getType().equals(that.getType()) && this.getNumber().equals(that.getNumber()) && this.getIssuerName().equals(that.getIssuerName()) && this.getIssuerCountry().equals(that.getIssuerCountry()) && this.getDateOfIssuance().equals(that.getDateOfIssuance()) && this.getDateOfExpiry().equals(that.getDateOfExpiry());
    }

    public int hashCode() {
        return Objects.hash(this.getType(), this.getNumber(), this.getIssuerName(), this.getIssuerCountry(), this.getDateOfIssuance(), this.getDateOfExpiry());
    }

    public static IDDocumentDescription parse(JSONObject jsonObject) throws ParseException {
        IDDocumentType type = new IDDocumentType(JSONObjectUtils.getString(jsonObject, "type"));
        String number = JSONObjectUtils.getString(jsonObject, "number");
        JSONObject issuerObject = JSONObjectUtils.getJSONObject(jsonObject, "issuer");
        String issuerName = JSONObjectUtils.getString(issuerObject, "name");
        ISO3166_1Alpha2CountryCode issuerCountry = ISO3166_1Alpha2CountryCode.parse(JSONObjectUtils.getString(issuerObject, "country"));
        SimpleDate dateOfIssuance = SimpleDate.parseISO8601String(JSONObjectUtils.getString(jsonObject, "date_of_issuance"));
        SimpleDate dateOfExpiry = SimpleDate.parseISO8601String(JSONObjectUtils.getString(jsonObject, "date_of_expiry"));
        return new IDDocumentDescription(type, number, issuerName, issuerCountry, dateOfIssuance, dateOfExpiry);
    }
}

